/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.phantom.resolver;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils {
    private static final String OS = System.getProperty("os.name").toLowerCase();

    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extract(ZipFile jar, String filename, File destination) throws IOException {
        ZipEntry entry = jar.getEntry(filename);
        if (entry == null) {
            throw new FileNotFoundException("cannot find file: " + filename + " in archive: " + jar.getName());
        }
        InputStream zipStream = jar.getInputStream(entry);
        FileOutputStream fileStream = null;
        try {
            fileStream = new FileOutputStream(destination);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = zipStream.read(buf)) != -1) {
                ((OutputStream)fileStream).write(buf, 0, i);
            }
        }
        finally {
            FileUtils.close(zipStream);
            FileUtils.close(fileStream);
        }
        return destination;
    }

    public static void close(Closeable stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    public static void setExecutable(File file) throws IOException {
        if (FileUtils.isUnix()) {
            try {
                Runtime.getRuntime().exec("chmod +x " + file.getAbsolutePath()).waitFor();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FileUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }
}

