/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.phantom.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.zip.ZipFile;
import org.jboss.arquillian.phantom.resolver.FileUtils;
import org.jboss.arquillian.phantom.resolver.PhantomJSBinary;
import org.jboss.arquillian.phantom.resolver.PhantomJSBinaryResolver;

public class PhantomJSBinaryResourceResolver
implements PhantomJSBinaryResolver {
    public static final String CHECKSUM_EXTENSION = "sha1";
    public static final String PHANTOMJS = "phantomjs" + (PhantomJSBinaryResourceResolver.isWindows() ? ".exe" : "");
    public static final String PHANTOMJS_RESOURCE = (PhantomJSBinaryResourceResolver.isWindows() ? "" : "bin/") + PHANTOMJS;
    public static final String PHANTOMJS_CHECKSUM = PHANTOMJS_RESOURCE + "." + "sha1";

    @Override
    public PhantomJSBinary resolve(String destination) throws IOException {
        return this.resolve(new File(destination));
    }

    @Override
    public PhantomJSBinary resolve(File destination) throws IOException {
        File realDestination;
        File file = realDestination = destination.isDirectory() ? new File(destination, PHANTOMJS) : destination;
        if (this.alreadyExists(realDestination)) {
            return new PhantomJSBinary(realDestination, new File(realDestination.getPath() + "." + CHECKSUM_EXTENSION));
        }
        return this.resolveFreshExtracted(realDestination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean alreadyExists(File destination) throws IOException {
        boolean bl;
        File extractedChecksumFile = new File(destination.getAbsolutePath() + "." + CHECKSUM_EXTENSION);
        if (!extractedChecksumFile.exists()) {
            return false;
        }
        URL inArchiveChecksumURL = PhantomJSBinaryResourceResolver.class.getClassLoader().getResource(PHANTOMJS_CHECKSUM);
        BufferedReader extractedReader = null;
        BufferedReader inArchiveReader = null;
        try {
            extractedReader = new BufferedReader(new InputStreamReader(new FileInputStream(extractedChecksumFile)));
            inArchiveReader = new BufferedReader(new InputStreamReader(inArchiveChecksumURL.openStream()));
            String extracted = extractedReader.readLine();
            String inArchive = inArchiveReader.readLine();
            bl = extracted != null && extracted.equals(inArchive);
        }
        catch (Throwable throwable) {
            FileUtils.close(extractedReader);
            FileUtils.close(inArchiveReader);
            throw throwable;
        }
        FileUtils.close(extractedReader);
        FileUtils.close(inArchiveReader);
        return bl;
    }

    protected File getJavaArchive(URL resource) {
        return new File(resource.getPath().split("!")[0].replace("file:", ""));
    }

    protected PhantomJSBinary resolveFromClassPath() throws IOException {
        return new PhantomJSBinary(PhantomJSBinaryResourceResolver.class.getClassLoader().getResource(PHANTOMJS).getFile(), PhantomJSBinaryResourceResolver.class.getClassLoader().getResource(PHANTOMJS).getFile() + "." + CHECKSUM_EXTENSION);
    }

    protected PhantomJSBinary resolveFreshExtracted(File destination) throws IOException {
        File checksum = new File(destination.getAbsolutePath() + "." + CHECKSUM_EXTENSION);
        if (!destination.exists()) {
            destination.delete();
        }
        if (checksum.exists()) {
            checksum.delete();
        }
        ZipFile jar = new ZipFile(this.getJavaArchive(PhantomJSBinaryResourceResolver.class.getClassLoader().getResource(PHANTOMJS_RESOURCE)));
        FileUtils.extract(jar, PHANTOMJS_RESOURCE, destination);
        FileUtils.extract(jar, PHANTOMJS_CHECKSUM, checksum);
        return new PhantomJSBinary(destination, checksum);
    }

    protected static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
    }
}

