/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.phantom.resolver;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.phantom.resolver.PhantomJSBinaryResolver;
import org.jboss.arquillian.phantom.resolver.ResolvingPhantomJSDriverService;
import org.jboss.arquillian.phantom.resolver.maven.MavenPhantomJSBinaryResolver;
import org.openqa.selenium.Capabilities;

public final class ResolverConfiguration {
    public static final String PREFER_RESOLVED = "phantomjs.prefer.resolved";
    private static final boolean DEFAULT_PREFER_RESOLVED = true;
    public static final String PHANTOMJS_BINARY_RESOLVER = "phantomjs.binary.resolver";
    private static final DefaultValue<PhantomJSBinaryResolver> DEFAULT_PHANTOMJS_BINARY_RESOLVER = new DefaultValue<PhantomJSBinaryResolver>(){

        @Override
        public PhantomJSBinaryResolver getDefault() {
            return new MavenPhantomJSBinaryResolver();
        }
    };
    public static final String PHANTOMJS_EXECUTABLE_PATH = "phantomjs.binary.path";
    private static final DefaultValue<String> DEFAULT_PHANTOMJS_EXECUTABLE_PATH = new DefaultValue<String>(){

        @Override
        public String getDefault() {
            try {
                LOG.log(Level.WARNING, "{0} capability isn't set, so resolving phantomjs binary as temporary file.", new String[]{ResolverConfiguration.PHANTOMJS_EXECUTABLE_PATH});
                File tempFile = File.createTempFile("phantomjs-binary-", "");
                tempFile.deleteOnExit();
                return tempFile.getAbsolutePath();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create temporary file for phantomjs binary", e);
            }
        }
    };
    public static final String PHANTOMJS_BINARY_VERSION = "phantomjs.binary.version";
    static final String DEFAULT_PHANTOMJS_BINARY_VERSION = "1.9.8";
    private static final Logger LOG = Logger.getLogger(ResolvingPhantomJSDriverService.class.getName());
    private Capabilities capabilities;

    private ResolverConfiguration(Capabilities capabilities) {
        this.capabilities = capabilities;
    }

    public static ResolverConfiguration get() {
        return new ResolverConfiguration(null);
    }

    public static ResolverConfiguration get(Capabilities capabilities) {
        return new ResolverConfiguration(capabilities);
    }

    public boolean preferResolved() {
        return this.capabilityOrDefault(PREFER_RESOLVED, true);
    }

    public PhantomJSBinaryResolver resolver() {
        return this.capabilityOrPropertyOrDefault(PHANTOMJS_BINARY_RESOLVER, DEFAULT_PHANTOMJS_BINARY_RESOLVER);
    }

    public File executablePath() {
        return new File(this.capabilityOrPropertyOrDefault(PHANTOMJS_EXECUTABLE_PATH, DEFAULT_PHANTOMJS_EXECUTABLE_PATH));
    }

    public String version() {
        return this.capabilityOrDefault(PHANTOMJS_BINARY_VERSION, DEFAULT_PHANTOMJS_BINARY_VERSION);
    }

    private <T> T capabilityOrDefault(String capabilityName, final T defaultValue) {
        return this.capabilityOrPropertyOrDefault(capabilityName, new DefaultValue<T>(){

            @Override
            public T getDefault() {
                return defaultValue;
            }
        });
    }

    private <T> T capabilityOrPropertyOrDefault(String capabilityOrPropertyName, DefaultValue<T> defaultValue) {
        Object object = System.getProperty(capabilityOrPropertyName);
        if (this.capabilities != null) {
            object = this.capabilities.getCapability(capabilityOrPropertyName);
        }
        if (object != null) {
            return (T)object;
        }
        return defaultValue.getDefault();
    }

    private static interface DefaultValue<T> {
        public T getDefault();
    }
}

