/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.rest.client;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.extension.rest.client.ArquillianResteasyResource;
import org.jboss.arquillian.extension.rest.client.Header;
import org.jboss.arquillian.extension.rest.client.Headers;
import org.jboss.arquillian.test.spi.TestEnricher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRestEnricher
implements TestEnricher {
    @Inject
    private Instance<ProtocolMetaData> metaDataInst;
    @Inject
    private Instance<Response> responseInst;

    public void enrich(Object testCase) {
    }

    public Object[] resolve(Method method) {
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        Consumes consumes = method.getDeclaringClass().getAnnotation(Consumes.class);
        Produces produces = method.getDeclaringClass().getAnnotation(Produces.class);
        if (this.responseInst.get() != null) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (!Response.class.isAssignableFrom(parameterTypes[i])) continue;
                values[i] = this.responseInst.get();
            }
        } else {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Annotation[] parameterAnnotations;
                for (Annotation annotation : parameterAnnotations = method.getParameterAnnotations()[i]) {
                    if (!(annotation instanceof ArquillianResteasyResource)) continue;
                    ArquillianResteasyResource arr = (ArquillianResteasyResource)annotation;
                    Class<?> clazz = parameterTypes[i];
                    if (this.isSupportedParameter(clazz)) {
                        values[i] = this.enrichByType(clazz, method, arr, consumes, produces);
                        continue;
                    }
                    throw new RuntimeException("Not able to provide a client injection for type " + clazz);
                }
            }
        }
        return values;
    }

    private void addHeaders(Map<String, String> headersMap, Header annotation) {
        if (null != annotation) {
            headersMap.put(annotation.name(), annotation.value());
        }
    }

    protected boolean allInSameContext(List<Servlet> servlets) {
        HashSet<String> context = new HashSet<String>();
        for (Servlet servlet : servlets) {
            context.add(servlet.getContextRoot());
        }
        return context.size() == 1;
    }

    protected abstract Object enrichByType(Class<?> var1, Method var2, ArquillianResteasyResource var3, Consumes var4, Produces var5);

    protected URI getBaseURL() {
        HTTPContext context = (HTTPContext)((ProtocolMetaData)this.metaDataInst.get()).getContext(HTTPContext.class);
        if (this.allInSameContext(context.getServlets())) {
            return ((Servlet)context.getServlets().get(0)).getBaseURI();
        }
        throw new IllegalStateException("No baseURL found in HTTPContext");
    }

    protected Map<String, String> getHeaders(Class<?> clazz, Method method) {
        Map<String, String> headers = this.getHeaders(clazz);
        headers.putAll(this.getHeaders(method));
        return headers;
    }

    protected Map<String, String> getHeaders(AnnotatedElement annotatedElement) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        Headers headersAnnotation = annotatedElement.getAnnotation(Headers.class);
        if (null != headersAnnotation && null != headersAnnotation.value()) {
            for (Header header : headersAnnotation.value()) {
                this.addHeaders(headersMap, header);
            }
        }
        this.addHeaders(headersMap, annotatedElement.getAnnotation(Header.class));
        return headersMap;
    }

    protected abstract boolean isSupportedParameter(Class<?> var1);
}

