/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.quickstart.resteasy.service.rs;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.arquillian.quickstart.resteasy.model.Stock;
import org.jboss.arquillian.quickstart.resteasy.service.StockService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StockServiceResource
implements StockService {
    private static final Map<Long, Stock> stockMap = new ConcurrentHashMap<Long, Stock>();
    private static final AtomicLong counter = new AtomicLong(1L);

    public StockServiceResource() {
        Stock stock = new Stock();
        stock.setId(1L);
        stock.setName("Acme");
        stock.setCode("ACM");
        stock.setValue(new BigDecimal(37.5));
        stock.setDate(new Date());
        stockMap.put(stock.getId(), stock);
    }

    @Override
    public Response createStock(Stock stock) {
        stock.setId(counter.incrementAndGet());
        stockMap.put(stock.getId(), stock);
        return Response.created((URI)URI.create("/stocks/" + stock.getId())).build();
    }

    @Override
    public void updateStock(@PathParam(value="id") long id, Stock stock) {
        Stock current = stockMap.get(id);
        if (current == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        current.setName(stock.getName());
        current.setCode(stock.getCode());
        current.setDate(stock.getDate());
        current.setValue(stock.getValue());
    }

    @Override
    public Stock getStock(@PathParam(value="id") long id) {
        Stock stock = stockMap.get(id);
        if (stock == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return stock;
    }

    @Override
    public List<Stock> getStocks(@DefaultValue(value="0") int startIndex, @DefaultValue(value="10") int size) {
        ArrayList<Stock> stocks = new ArrayList<Stock>(size);
        Iterator<Stock> iter = stockMap.values().iterator();
        int count = 0;
        while (iter.hasNext() && count < startIndex) {
            iter.next();
        }
        while (iter.hasNext() && count < size) {
            stocks.add(iter.next());
        }
        return stocks;
    }

    @Override
    public Response deleteStock(@PathParam(value="id") long id) {
        if (stockMap.remove(id) == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return Response.ok().build();
    }
}

