/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.client;

import java.io.File;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.spring.deployer.configuration.SpringDeployerConfiguration;
import org.jboss.arquillian.spring.deployer.dependency.AbstractDependencyResolver;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringProtocolArchiveProcessor
implements ProtocolArchiveProcessor {
    @Inject
    private Instance<SpringDeployerConfiguration> configuration;
    @Inject
    private Instance<AbstractDependencyResolver> dependencyResolver;

    public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
        if (this.getConfiguration().isAutoPackaging()) {
            if (this.isEnterpriseArchive(testDeployment.getApplicationArchive()) || this.isWebArchive(testDeployment.getApplicationArchive())) {
                this.addDependencies(testDeployment.getApplicationArchive());
            } else if (this.isEnterpriseArchive(protocolArchive) || this.isWebArchive(protocolArchive)) {
                this.addDependencies(protocolArchive);
            }
        }
    }

    private boolean isEnterpriseArchive(Archive<?> archive) {
        return archive.getName().endsWith(".ear");
    }

    private boolean isWebArchive(Archive<?> archive) {
        return archive.getName().endsWith(".war");
    }

    private void addDependencies(Archive<?> archive) {
        File[] dependencies = this.getDependencies();
        if (this.isEnterpriseArchive(archive)) {
            ((EnterpriseArchive)archive).addAsModules(dependencies);
        } else if (this.isWebArchive(archive)) {
            ((WebArchive)archive).addAsLibraries(dependencies);
        } else {
            throw new RuntimeException("Unsupported archive format[" + archive.getClass().getSimpleName() + ", " + archive.getName() + "] for Spring testing. Please use WAR or EAR.");
        }
    }

    public SpringDeployerConfiguration getConfiguration() {
        return (SpringDeployerConfiguration)this.configuration.get();
    }

    public File[] getDependencies() {
        return this.dependencyResolver.get() != null ? ((AbstractDependencyResolver)this.dependencyResolver.get()).resolveDependencies() : null;
    }
}

