/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.deployer.client;

import java.util.Collections;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.spring.deployer.configuration.SpringDeployerConfiguration;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringDeployerConfigurationProducer {
    @Inject
    private Instance<ArquillianDescriptor> descriptor;
    @Inject
    @ApplicationScoped
    private InstanceProducer<SpringDeployerConfiguration> deployerConfiguration;

    public void initConfiguration(@Observes(precedence=2) BeforeSuite beforeSuiteEvent) {
        SpringDeployerConfiguration config = this.getConfiguration(this.descriptor);
        this.deployerConfiguration.set((Object)config);
    }

    private SpringDeployerConfiguration getConfiguration(Instance<ArquillianDescriptor> descriptor) {
        Map<String, String> properties = this.getExtensionProperties((ArquillianDescriptor)descriptor.get());
        SpringDeployerConfiguration result = new SpringDeployerConfiguration();
        result.setAutoPackaging(this.getBooleanProperty(properties, "autoPackage", true));
        result.setEnableCache(this.getBooleanProperty(properties, "enableCache", true));
        result.setUseMavenOffline(this.getBooleanProperty(properties, "useMavenOffline", false));
        result.setImportPomDependencies(this.getBooleanProperty(properties, "importPomDependencies", true));
        result.setPomFile(this.getStringProperty(properties, "pomFile", "pom.xml"));
        result.setSpringVersion(this.getStringProperty(properties, "springVersion", null));
        result.setCglibVersion(this.getStringProperty(properties, "cglibVersion", null));
        result.setIncludeSnowdrop(this.getBooleanProperty(properties, "includeSnowdrop", false));
        result.setSnowdropVersion(this.getStringProperty(properties, "snowdropVersion", null));
        return result;
    }

    private Map<String, String> getExtensionProperties(ArquillianDescriptor desc) {
        for (ExtensionDef extensionDef : desc.getExtensions()) {
            if (!"spring-deployer".equals(extensionDef.getExtensionName())) continue;
            return extensionDef.getExtensionProperties();
        }
        return Collections.emptyMap();
    }

    private boolean getBooleanProperty(Map<String, String> properties, String propertyName, boolean defaultValue) {
        if (properties.containsKey(propertyName)) {
            return Boolean.parseBoolean(properties.get(propertyName));
        }
        return defaultValue;
    }

    private String getStringProperty(Map<String, String> properties, String propertyName, String defaultValue) {
        if (properties.containsKey(propertyName)) {
            return properties.get(propertyName);
        }
        return defaultValue;
    }
}

