/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.javaconfig.client;

import org.jboss.arquillian.spring.integration.context.ClientApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.ClientTestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.javaconfig.utils.AnnotationApplicationContextProducer;
import org.jboss.arquillian.spring.integration.javaconfig.utils.DefaultConfigurationClassesProcessor;
import org.jboss.arquillian.spring.integration.test.annotation.SpringClientAnnotationConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.springframework.context.ApplicationContext;

public class AnnotationClientApplicationContextProducer
implements ClientApplicationContextProducer {
    private final DefaultConfigurationClassesProcessor configurationClassesProcessor = new DefaultConfigurationClassesProcessor();
    private final AnnotationApplicationContextProducer annotationApplicationContextProducer = new AnnotationApplicationContextProducer();

    public boolean supports(TestClass testClass) {
        return testClass.isAnnotationPresent(SpringClientAnnotationConfiguration.class);
    }

    public ClientTestScopeApplicationContext createApplicationContext(TestClass testClass) {
        return new ClientTestScopeApplicationContext(this.getApplicationContext(testClass), testClass, true);
    }

    private ApplicationContext getApplicationContext(TestClass testClass) {
        SpringClientAnnotationConfiguration springConfiguration = (SpringClientAnnotationConfiguration)testClass.getAnnotation(SpringClientAnnotationConfiguration.class);
        Class wrappedTestClass = testClass.getJavaClass();
        Class<?>[] classes = this.configurationClassesProcessor.findConfigurationClasses(springConfiguration, wrappedTestClass);
        String[] packages = this.configurationClassesProcessor.findPackages(springConfiguration, wrappedTestClass);
        return this.annotationApplicationContextProducer.createAnnotatedApplicationContext(testClass, packages, classes);
    }
}

