/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.container;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityActions {
    private SecurityActions() {
    }

    public static boolean isClassPresent(String name) {
        try {
            ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static InputStream getResource(String resourceName) {
        return SecurityActions.getThreadContextClassLoader().getResourceAsStream(resourceName);
    }

    public static Class<?> classForName(String name) {
        try {
            ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class by name " + name, e);
        }
    }

    private static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

