/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.container;

import java.util.List;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.spring.integration.context.RemoteApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.RemoteTestScopeApplicationContext;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class SpringContainerApplicationContextProducer {
    private static final Logger log = Logger.getLogger(SpringContainerApplicationContextProducer.class.getName());
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    @ApplicationScoped
    private InstanceProducer<RemoteTestScopeApplicationContext> testApplicationContext;

    public void initApplicationContext(@Observes BeforeClass beforeClass) {
        ServiceLoader loader = (ServiceLoader)this.serviceLoader.get();
        List applicationContextProducers = (List)loader.all(RemoteApplicationContextProducer.class);
        for (RemoteApplicationContextProducer applicationContextProducer : applicationContextProducers) {
            RemoteTestScopeApplicationContext applicationContext;
            if (!applicationContextProducer.supports(beforeClass.getTestClass()) || (applicationContext = (RemoteTestScopeApplicationContext)applicationContextProducer.createApplicationContext(beforeClass.getTestClass())) == null) continue;
            this.testApplicationContext.set((Object)applicationContext);
            log.fine("Successfully created application context for test class: " + beforeClass.getTestClass().getName());
            break;
        }
    }
}

