/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.container;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecurityActions {
    private SecurityActions() {
    }

    public static boolean isClassPresent(String name) {
        try {
            ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
            classLoader.loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static InputStream getResource(String resourceName) {
        return SecurityActions.getThreadContextClassLoader().getResourceAsStream(resourceName);
    }

    public static Class<?> classForName(String name) {
        try {
            ClassLoader classLoader = SecurityActions.getThreadContextClassLoader();
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class by name " + name, e);
        }
    }

    public static Method[] getStaticMethodsWithAnnotation(final Class<?> source, final Class<? extends Annotation> annotationClass) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                ArrayList<Method> foundMethods = new ArrayList<Method>();
                for (Class nextSource = source; nextSource != Object.class; nextSource = nextSource.getSuperclass()) {
                    for (Method method : nextSource.getDeclaredMethods()) {
                        if (!Modifier.isStatic(method.getModifiers()) || !method.isAnnotationPresent(annotationClass)) continue;
                        if (!method.isAccessible()) {
                            method.setAccessible(true);
                        }
                        foundMethods.add(method);
                    }
                }
                return foundMethods.toArray(new Method[foundMethods.size()]);
            }
        });
    }

    private static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }
}

