/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.lifecycle;

import java.util.Collection;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.spring.integration.context.ApplicationContextDestroyer;
import org.jboss.arquillian.spring.integration.context.ApplicationContextProducer;
import org.jboss.arquillian.spring.integration.context.TestScopeApplicationContext;
import org.jboss.arquillian.spring.integration.event.ApplicationContextCreatedEvent;
import org.jboss.arquillian.spring.integration.event.ApplicationContextDestroyedEvent;
import org.jboss.arquillian.spring.integration.event.ApplicationContextEvent;
import org.jboss.arquillian.spring.integration.test.annotation.ContextLifeCycle;
import org.jboss.arquillian.spring.integration.test.annotation.ContextLifeCycleMode;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractApplicationContextLifecycleHandler<TProd extends ApplicationContextProducer<T>, T extends TestScopeApplicationContext> {
    private static final ContextLifeCycleMode DEFAULT_LIFE_CYCLE_MODE = ContextLifeCycleMode.TEST_CASE;
    @Inject
    private Instance<ServiceLoader> serviceLoaderInstance;
    @Inject
    private Event<ApplicationContextEvent> applicationContextEvent;

    protected abstract T getApplicationContext();

    protected abstract void setApplicationContext(T var1);

    protected abstract Class<TProd> getProducerClass();

    public void beforeClass(@Observes BeforeClass event) {
        this.createTestApplicationContext(event.getTestClass());
    }

    public void beforeTest(@Observes Before event) {
        this.createTestApplicationContext(event.getTestClass());
    }

    public void afterTest(@Observes After event) {
        ContextLifeCycleMode mode = this.getContextLifeCycleMode(event.getTestClass());
        if (mode == ContextLifeCycleMode.TEST) {
            this.destroyTestApplicationContext();
        }
    }

    public void afterSuite(@Observes AfterSuite event) {
        this.destroyTestApplicationContext();
    }

    private void createTestApplicationContext(TestClass testClass) {
        if (this.getApplicationContext() != null && ((TestScopeApplicationContext)this.getApplicationContext()).getTestClass().getJavaClass().equals(testClass.getJavaClass())) {
            return;
        }
        T applicationContext = this.createApplicationContext(testClass);
        if (applicationContext != null) {
            this.applicationContextEvent.fire((Object)new ApplicationContextCreatedEvent((TestScopeApplicationContext)applicationContext));
            this.setApplicationContext(applicationContext);
        }
    }

    private T createApplicationContext(TestClass testClass) {
        ServiceLoader serviceLoader = (ServiceLoader)this.serviceLoaderInstance.get();
        Collection applicationContextProducers = serviceLoader.all(this.getProducerClass());
        for (ApplicationContextProducer applicationContextProducer : applicationContextProducers) {
            if (!applicationContextProducer.supports(testClass)) continue;
            return applicationContextProducer.createApplicationContext(testClass);
        }
        return null;
    }

    private void destroyTestApplicationContext() {
        T applicationContext = this.getApplicationContext();
        if (applicationContext != null) {
            this.destroyApplicationContext((TestScopeApplicationContext)applicationContext);
            this.applicationContextEvent.fire((Object)new ApplicationContextDestroyedEvent((TestScopeApplicationContext)applicationContext));
        }
    }

    private void destroyApplicationContext(TestScopeApplicationContext applicationContext) {
        this.getService(ApplicationContextDestroyer.class).destroyApplicationContext(applicationContext);
    }

    private ContextLifeCycleMode getContextLifeCycleMode(TestClass testClass) {
        ContextLifeCycle contextLifeCycle = (ContextLifeCycle)testClass.getAnnotation(ContextLifeCycle.class);
        if (contextLifeCycle != null) {
            return contextLifeCycle.value();
        }
        return DEFAULT_LIFE_CYCLE_MODE;
    }

    private <T> T getService(Class<T> clazz) {
        Collection collection = ((ServiceLoader)this.serviceLoaderInstance.get()).all(clazz);
        return (T)collection.iterator().next();
    }
}

