/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.client;

import java.util.Collections;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.spring.integration.configuration.SpringIntegrationConfiguration;

public class SpringIntegrationConfigurationProducer {
    @Inject
    @ApplicationScoped
    private InstanceProducer<SpringIntegrationConfiguration> extensionConfiguration;

    public void initConfiguration(@Observes ArquillianDescriptor descriptor) {
        SpringIntegrationConfiguration config = this.getConfiguration(descriptor);
        this.extensionConfiguration.set((Object)config);
    }

    private SpringIntegrationConfiguration getConfiguration(ArquillianDescriptor descriptor) {
        Map<String, String> properties = this.getExtensionProperties(descriptor);
        return new SpringIntegrationConfiguration(properties);
    }

    private Map<String, String> getExtensionProperties(ArquillianDescriptor desc) {
        for (ExtensionDef extensionDef : desc.getExtensions()) {
            if (!"spring".equals(extensionDef.getExtensionName())) continue;
            return extensionDef.getExtensionProperties();
        }
        return Collections.emptyMap();
    }

    private String getStringProperty(Map<String, String> properties, String propertyName, String defaultValue) {
        if (properties.containsKey(propertyName)) {
            return properties.get(propertyName);
        }
        return defaultValue;
    }
}

