/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.enricher;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.jboss.arquillian.spring.integration.container.SecurityActions;
import org.jboss.arquillian.spring.integration.context.TestScopeApplicationContext;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractSpringInjectionEnricher<T extends TestScopeApplicationContext>
implements TestEnricher {
    private static final Logger log = Logger.getLogger(AbstractSpringInjectionEnricher.class.getName());

    public abstract T getTestScopeApplicationContext();

    public void enrich(Object testCase) {
        if (SecurityActions.isClassPresent("org.springframework.context.ApplicationContext") && this.getApplicationContextExists()) {
            this.injectClass(testCase);
        }
    }

    public Object[] resolve(Method method) {
        return new Object[method.getParameterTypes().length];
    }

    private void injectClass(Object testCase) {
        ApplicationContext applicationContext = this.getApplicationContext();
        if (applicationContext != null) {
            log.fine("Injecting dependencies into test case: " + testCase.getClass().getName());
            this.injectDependencies(applicationContext, testCase);
        }
    }

    private void injectDependencies(ApplicationContext applicationContext, Object testCase) {
        AutowireCapableBeanFactory beanFactory = applicationContext.getAutowireCapableBeanFactory();
        beanFactory.autowireBeanProperties(testCase, 0, false);
        beanFactory.initializeBean(testCase, testCase.getClass().getName());
    }

    private ApplicationContext getApplicationContext() {
        if (this.getTestScopeApplicationContext() != null) {
            return ((TestScopeApplicationContext)this.getTestScopeApplicationContext()).getApplicationContext();
        }
        return null;
    }

    private boolean getApplicationContextExists() {
        return this.getTestScopeApplicationContext() != null;
    }
}

