/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.transaction.impl.client;

import java.util.Collections;
import java.util.Map;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.transaction.api.annotation.TransactionMode;
import org.jboss.arquillian.transaction.impl.configuration.TransactionConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionConfigurationProducer {
    public static final String TRANSACTION_EXTENSION = "transaction";
    public static final String MANAGER_PROPERTY_NAME = "manager";
    public static final String DEFAULT_TRANSACTION_MODE_PROPERTY_NAME = "transactionDefaultMode";
    @Inject
    private Instance<ArquillianDescriptor> descriptor;
    @Inject
    @ApplicationScoped
    private InstanceProducer<TransactionConfiguration> configurationInstance;

    public void loadConfiguration(@Observes BeforeSuite beforeSuiteEvent) {
        TransactionConfiguration config = this.getConfiguration((ArquillianDescriptor)this.descriptor.get());
        this.configurationInstance.set((Object)config);
    }

    private TransactionConfiguration getConfiguration(ArquillianDescriptor arquillianDescriptor) {
        Map<String, String> extensionProperties = this.getExtensionProperties(arquillianDescriptor);
        TransactionConfiguration configuration = new TransactionConfiguration();
        configuration.setManager(extensionProperties.get(MANAGER_PROPERTY_NAME));
        String transactionDefaultMode = extensionProperties.get(DEFAULT_TRANSACTION_MODE_PROPERTY_NAME);
        if (transactionDefaultMode != null && transactionDefaultMode.length() > 0) {
            configuration.setTransactionDefaultMode(TransactionMode.valueOf((String)transactionDefaultMode));
        }
        return configuration;
    }

    private Map<String, String> getExtensionProperties(ArquillianDescriptor arquillianDescriptor) {
        for (ExtensionDef extensionDef : arquillianDescriptor.getExtensions()) {
            if (!TRANSACTION_EXTENSION.equals(extensionDef.getExtensionName())) continue;
            return extensionDef.getExtensionProperties();
        }
        return Collections.emptyMap();
    }
}

