/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.transaction.impl.configuration;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jboss.arquillian.transaction.api.annotation.TransactionMode;
import org.jboss.arquillian.transaction.impl.configuration.TransactionConfiguration;

public class TransactionConfigurationConverter {
    public static String exportToProperties(TransactionConfiguration configuration) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            Properties properties = new Properties();
            TransactionConfigurationConverter.setPropertyValue(properties, "manager", configuration.getManager());
            TransactionConfigurationConverter.setPropertyValue(properties, "transactionDefaultMode", configuration.getTransactionDefaultMode().name());
            properties.store(outputStream, "arquillian-transaction-configuration");
            String string = ((Object)outputStream).toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not export the configuration..", e);
        }
        finally {
            TransactionConfigurationConverter.close(outputStream);
        }
    }

    public static TransactionConfiguration importFromProperties(InputStream inputStream) {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            TransactionConfiguration transactionConfiguration = new TransactionConfiguration();
            transactionConfiguration.setManager(TransactionConfigurationConverter.getPropertyValue(properties, "manager"));
            String transactionDefaultMode = TransactionConfigurationConverter.getPropertyValue(properties, "transactionDefaultMode");
            if (transactionDefaultMode != null && transactionDefaultMode.length() > 0) {
                transactionConfiguration.setTransactionDefaultMode(TransactionMode.valueOf((String)transactionDefaultMode));
            }
            TransactionConfiguration transactionConfiguration2 = transactionConfiguration;
            return transactionConfiguration2;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not import the configuration.", e);
        }
        finally {
            TransactionConfigurationConverter.close(inputStream);
        }
    }

    private static String getPropertyValue(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        if (value == null || "".equals(value.trim())) {
            return null;
        }
        return value;
    }

    private static void setPropertyValue(Properties properties, String propertyName, String value) {
        properties.setProperty(propertyName, TransactionConfigurationConverter.getPropertyValueOrDefault(value));
    }

    private static String getPropertyValueOrDefault(String value) {
        return value != null ? value : "";
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to close output stream.", e);
            }
        }
    }
}

