/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.transaction.spring.provider;

import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.transaction.spi.annotation.TransactionScope;
import org.jboss.arquillian.transaction.spi.provider.TransactionProvider;
import org.jboss.arquillian.transaction.spi.test.TransactionalTest;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

public abstract class AbstractSpringTransactionProvider
implements TransactionProvider {
    @Inject
    @TransactionScope
    InstanceProducer<PlatformTransactionManager> transactionManagerInstance;
    @Inject
    @TransactionScope
    InstanceProducer<TransactionStatus> transactionStatusInstance;

    public void beginTransaction(TransactionalTest transactionalTest) {
        PlatformTransactionManager transactionManager = this.getTransactionManager(transactionalTest.getManager());
        this.transactionManagerInstance.set((Object)transactionManager);
        DefaultTransactionAttribute transactionDefinition = this.createTransactionDefinition();
        TransactionStatus transactionStatus = transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        this.transactionStatusInstance.set((Object)transactionStatus);
    }

    public void commitTransaction(TransactionalTest transactionalTest) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)this.transactionManagerInstance.get();
        TransactionStatus transactionStatus = (TransactionStatus)this.transactionStatusInstance.get();
        transactionManager.commit(transactionStatus);
    }

    public void rollbackTransaction(TransactionalTest transactionalTest) {
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)this.transactionManagerInstance.get();
        TransactionStatus transactionStatus = (TransactionStatus)this.transactionStatusInstance.get();
        transactionManager.rollback(transactionStatus);
    }

    private DefaultTransactionAttribute createTransactionDefinition() {
        return new DefaultTransactionAttribute();
    }

    private PlatformTransactionManager getTransactionManager(String transactionManagerName) {
        ApplicationContext applicationContext = this.getApplicationContext();
        return (PlatformTransactionManager)applicationContext.getBean(transactionManagerName, PlatformTransactionManager.class);
    }

    protected abstract ApplicationContext getApplicationContext();
}

