/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.deployment;

import java.util.Collection;
import java.util.LinkedList;
import org.jboss.arquillian.container.test.spi.RemoteLoadableExtension;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.container.test.spi.client.deployment.AuxiliaryArchiveAppender;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.WarpRemoteExtension;
import org.jboss.arquillian.warp.WarpTest;
import org.jboss.arquillian.warp.impl.server.lifecycle.LifecycleManagerStoreImpl;
import org.jboss.arquillian.warp.servlet.AfterServlet;
import org.jboss.arquillian.warp.servlet.BeforeServlet;
import org.jboss.arquillian.warp.spi.LifecycleManagerStore;
import org.jboss.arquillian.warp.spi.WarpDeploymentEnrichmentExtension;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentEnricher
implements ApplicationArchiveProcessor,
AuxiliaryArchiveAppender,
ProtocolArchiveProcessor {
    static String[] REQUIRED_WARP_PACKAGES = new String[]{"org.jboss.arquillian.warp.spi", "org.jboss.arquillian.warp.spi.context", "org.jboss.arquillian.warp.spi.event", "org.jboss.arquillian.warp.spi.exception", "org.jboss.arquillian.warp.spi.servlet.event", "org.jboss.arquillian.warp.impl.server.inspection", "org.jboss.arquillian.warp.impl.server.enrichment", "org.jboss.arquillian.warp.impl.server.event", "org.jboss.arquillian.warp.impl.server.execution", "org.jboss.arquillian.warp.impl.server.lifecycle", "org.jboss.arquillian.warp.impl.server.provider", "org.jboss.arquillian.warp.impl.server.request", "org.jboss.arquillian.warp.impl.server.test", "org.jboss.arquillian.warp.impl.shared", "org.jboss.arquillian.warp.impl.utils", "org.jboss.arquillian.warp.servlet.event", "org.jboss.arquillian.warp.servlet.provider"};
    @Inject
    Instance<ServiceLoader> serviceLoader;
    @Inject
    Instance<TestClass> testClass;

    public void process(Archive<?> applicationArchive, TestClass testClass) {
        if (testClass.isAnnotationPresent(WarpTest.class) && applicationArchive instanceof WebArchive) {
            WebArchive webArchive = (WebArchive)applicationArchive;
            Collection lifecycleExtensions = ((ServiceLoader)this.serviceLoader.get()).all(WarpDeploymentEnrichmentExtension.class);
            for (WarpDeploymentEnrichmentExtension extension : lifecycleExtensions) {
                JavaArchive library = extension.getEnrichmentLibrary();
                if (library != null) {
                    webArchive.addAsLibrary((Archive)library);
                }
                extension.enrichWebArchive(webArchive);
            }
        }
    }

    public Archive<?> createAuxiliaryArchive() {
        TestClass testClass = (TestClass)this.testClass.get();
        if (testClass.isAnnotationPresent(WarpTest.class)) {
            JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"arquillian-warp.jar");
            archive.addClass(Inspection.class);
            archive.addClasses(new Class[]{BeforeServlet.class, AfterServlet.class});
            for (String packageName : REQUIRED_WARP_PACKAGES) {
                archive.addPackage(packageName);
            }
            archive.addClass(WarpRemoteExtension.class);
            archive.addAsServiceProvider(RemoteLoadableExtension.class, new Class[]{WarpRemoteExtension.class});
            archive.addAsServiceProvider(LifecycleManagerStore.class, new Class[]{LifecycleManagerStoreImpl.class});
            return archive;
        }
        return null;
    }

    public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
        TestClass testClass = (TestClass)this.testClass.get();
        if (testClass.isAnnotationPresent(WarpTest.class)) {
            Archive applicationArchive = testDeployment.getApplicationArchive();
            LinkedList<ArchivePath> classPathsToRemove = new LinkedList<ArchivePath>();
            for (ArchivePath archivePath : applicationArchive.getContent().keySet()) {
                String path = archivePath.get();
                String classPath = testClass.getName().replace(".", "/");
                if (!path.matches("/WEB-INF/classes/" + classPath + "(\\$[0-9]*)?\\.class")) continue;
                classPathsToRemove.add(archivePath);
            }
            for (ArchivePath archivePath : classPathsToRemove) {
                applicationArchive.delete(archivePath);
            }
        }
    }
}

