/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpRequestEnrichmentFilter;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpRequestEnrichmentService;
import org.jboss.arquillian.warp.impl.client.event.FilterHttpRequest;
import org.jboss.arquillian.warp.impl.client.execution.SynchronizationPoint;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.netty.handler.codec.http.HttpRequest;

public class DefaultHttpRequestEnrichmentFilter
implements HttpRequestEnrichmentFilter {
    @Inject
    private Event<FilterHttpRequest> tryEnrichRequest;
    private HttpRequestEnrichmentService enrichmentService;

    public void filter(HttpRequest request) {
        block5: {
            WarpContext context = WarpContextStore.get();
            try {
                SynchronizationPoint synchronization;
                if (context != null && (synchronization = context.getSynchronization()).isWaitingForRequests()) {
                    try {
                        this.tryEnrichRequest.fire((Object)new FilterHttpRequest(request, this.enrichmentService));
                    }
                    catch (Exception originalException) {
                        ClientWarpExecutionException explainingException = new ClientWarpExecutionException("enriching request failed: " + originalException.getMessage(), (Throwable)originalException);
                        context.pushException((Exception)explainingException);
                    }
                }
            }
            catch (Exception e) {
                if (context == null) break block5;
                context.pushException(e);
            }
        }
    }

    public void initialize(HttpRequestEnrichmentService enrichmentService) {
        this.enrichmentService = enrichmentService;
    }
}

