/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.warp.RequestObserver;
import org.jboss.arquillian.warp.client.filter.RequestFilter;
import org.jboss.arquillian.warp.client.filter.http.HttpMethod;
import org.jboss.arquillian.warp.client.filter.http.HttpRequestFilter;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpRequestEnrichmentService;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroup;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.impl.utils.SerializationUtils;
import org.jboss.arquillian.warp.impl.utils.URLUtils;
import org.jboss.arquillian.warp.spi.WarpCommons;
import org.jboss.arquillian.warp.spi.observer.RequestObserverChainManager;
import org.jboss.netty.handler.codec.http.HttpRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpRequestEnrichmentService
implements HttpRequestEnrichmentService {
    private Logger log = Logger.getLogger("Warp");

    @Override
    public Collection<RequestPayload> getMatchingPayloads(HttpRequest request) {
        Collection<WarpGroup> groups = this.warpContext().getAllGroups();
        HttpRequestWrapper httpRequest = new HttpRequestWrapper(request);
        LinkedList<RequestPayload> payloads = new LinkedList<RequestPayload>();
        block0: for (WarpGroup group : groups) {
            LinkedList<RequestObserver> observers = new LinkedList<RequestObserver>();
            if (group.getObserver() != null) {
                observers.add(group.getObserver());
            }
            Collection<RequestObserverChainManager> observerChainManagers = this.warpContext().getObserverChainManagers();
            for (RequestObserverChainManager chainManager : observerChainManagers) {
                chainManager.manageObserverChain(observers, HttpRequestFilter.class);
            }
            for (RequestObserver observer : observers) {
                if (!this.isHttpFilter(observer)) {
                    this.log.warning("One of the defined observers (" + observer.toString() + ") of class " + observer.getClass() + " doesn't match expected type (" + HttpRequestFilter.class + ") - continuing without processing this request group");
                    continue block0;
                }
                RequestFilter filter = (RequestFilter)observer;
                if (filter.matches((Object)httpRequest)) continue;
                continue block0;
            }
            payloads.add(group.generateRequestPayload());
        }
        return payloads;
    }

    @Override
    public void enrichRequest(HttpRequest request, RequestPayload payload) {
        if (WarpCommons.debugMode()) {
            System.out.println("                (W) " + request.getUri());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Warp request: " + request.getUri());
        }
        try {
            String requestEnrichment = SerializationUtils.serializeToBase64(payload);
            request.setHeader("X-Arq-Enrichment-Request", Arrays.asList(requestEnrichment));
        }
        catch (Throwable originalException) {
            ClientWarpExecutionException explainingException = new ClientWarpExecutionException("enriching request failed:\n" + originalException.getMessage(), originalException);
            this.warpContext().pushException((Exception)explainingException);
        }
    }

    private boolean isHttpFilter(RequestObserver observer) {
        return observer instanceof RequestFilter && this.isType((RequestFilter<?>)((RequestFilter)observer), (Type)((Object)org.jboss.arquillian.warp.client.filter.http.HttpRequest.class));
    }

    private boolean isType(RequestFilter<?> filter, Type expectedType) {
        Type[] interfaces;
        for (Type type : interfaces = filter.getClass().getGenericInterfaces()) {
            ParameterizedType parametrizedType;
            if (!(type instanceof ParameterizedType) || (parametrizedType = (ParameterizedType)type).getRawType() != RequestFilter.class) continue;
            return parametrizedType.getActualTypeArguments()[0] == expectedType;
        }
        return false;
    }

    private WarpContext warpContext() {
        return WarpContextStore.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HttpRequestWrapper
    implements org.jboss.arquillian.warp.client.filter.http.HttpRequest {
        private HttpRequest request;

        public HttpRequestWrapper(HttpRequest request) {
            this.request = request;
        }

        public HttpMethod getMethod() {
            return HttpMethod.valueOf((String)this.request.getMethod().getName());
        }

        public String getUri() {
            return this.request.getUri();
        }

        public URL getUrl() {
            return URLUtils.buildUrl(this.request.getUri(), new String[0]);
        }

        public String getHeader(String name) {
            return this.request.getHeader(name);
        }

        public List<String> getHeaders(String name) {
            return this.request.getHeaders(name);
        }

        public List<Map.Entry<String, String>> getHeaders() {
            return this.request.getHeaders();
        }

        public boolean containsHeader(String name) {
            return this.request.containsHeader(name);
        }

        public Set<String> getHeaderNames() {
            return this.request.getHeaderNames();
        }
    }
}

