/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.jboss.arquillian.warp.RequestObserver;
import org.jboss.arquillian.warp.client.execution.SingleInspectionSpecifier;
import org.jboss.arquillian.warp.client.filter.http.HttpRequestFilter;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroup;
import org.jboss.arquillian.warp.impl.client.observer.FaviconIgnore;
import org.jboss.arquillian.warp.impl.client.observer.OnlyFirstRequest;
import org.jboss.arquillian.warp.spi.observer.RequestObserverChainManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequestObserverChainManager
implements RequestObserverChainManager {
    private RequestObserver FAVICON_IGNORE = new FaviconIgnore();
    private AtomicStampedReference<OnlyFirstRequest> firstRequestObserver = new AtomicStampedReference<Object>(null, 0);

    public Deque<RequestObserver> manageObserverChain(Deque<RequestObserver> observers, Class<? extends RequestObserver> expectedObserverType) {
        if (expectedObserverType == HttpRequestFilter.class) {
            if (this.allGroups().size() == 1 && this.allGroups().iterator().next().getId() == SingleInspectionSpecifier.GROUP_ID) {
                observers.addFirst((RequestObserver)this.retrieveFirstRequestObserver());
            }
            observers.addFirst(this.FAVICON_IGNORE);
        }
        return observers;
    }

    public int priotity() {
        return 0;
    }

    private Collection<WarpGroup> allGroups() {
        return this.warpContext().getAllGroups();
    }

    private WarpContext warpContext() {
        return WarpContextStore.get();
    }

    private OnlyFirstRequest retrieveFirstRequestObserver() {
        int key = this.warpContext().hashCode();
        int[] stampHolder = new int[1];
        OnlyFirstRequest onlyFirstRequest = this.firstRequestObserver.get(stampHolder);
        if (key != stampHolder[0]) {
            this.firstRequestObserver.compareAndSet(onlyFirstRequest, new OnlyFirstRequest(), stampHolder[0], key);
        }
        onlyFirstRequest = this.firstRequestObserver.get(stampHolder);
        if (stampHolder[0] != key) {
            this.warpContext().pushException(new IllegalStateException("There should be only one concurrent Warp execution"));
        }
        return onlyFirstRequest;
    }
}

