/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpResponseDeenrichmentService;
import org.jboss.arquillian.warp.impl.client.event.VerifyResponsePayload;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;
import org.jboss.arquillian.warp.impl.utils.SerializationUtils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class DefaultResponseDeenrichmentService
implements HttpResponseDeenrichmentService {
    private final Logger log = Logger.getLogger(HttpResponseDeenrichmentService.class.getName());
    @Inject
    private Event<VerifyResponsePayload> verifyResponsePayload;

    public boolean isEnriched(HttpResponse response) {
        return this.getHeader(response) != null;
    }

    public void deenrichResponse(HttpResponse response) {
        WarpContext context = WarpContextStore.get();
        try {
            ChannelBuffer content = response.getContent();
            long originalLength = HttpHeaders.getContentLength((HttpMessage)response);
            int payloadLength = Integer.valueOf(this.getHeader(response));
            String responseEnrichment = content.toString(0, payloadLength, Charset.defaultCharset());
            content.readerIndex(payloadLength);
            content.discardReadBytes();
            HttpHeaders.setContentLength((HttpMessage)response, (long)(originalLength - (long)payloadLength));
            ResponsePayload payload = (ResponsePayload)SerializationUtils.deserializeFromBase64(responseEnrichment);
            response.setStatus(HttpResponseStatus.valueOf((int)payload.getStatus()));
            for (Map.Entry<String, List<String>> entry : payload.getHeaders().entrySet()) {
                response.setHeader(entry.getKey(), (Iterable)entry.getValue());
            }
            if (context != null) {
                this.verifyResponsePayload.fire((Object)new VerifyResponsePayload(payload));
                context.pushResponsePayload(payload);
            }
        }
        catch (Exception originalException) {
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            if (context != null) {
                ClientWarpExecutionException explainingException = originalException instanceof ClientWarpExecutionException ? (ClientWarpExecutionException)originalException : new ClientWarpExecutionException("deenriching response failed: " + originalException.getMessage(), (Throwable)originalException);
                context.pushException((Exception)explainingException);
            }
            this.log.log(Level.WARNING, "Unable to push exception to WarpContext", originalException);
        }
    }

    private String getHeader(HttpResponse response) {
        return response.getHeader("X-Arq-Enrichment-Response");
    }
}

