/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.util.Collection;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.warp.client.exception.MultipleGroupsPerRequestException;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpRequestEnrichmentService;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpResponseDeenrichmentService;
import org.jboss.arquillian.warp.impl.client.event.DeenrichHttpResponse;
import org.jboss.arquillian.warp.impl.client.event.EnrichHttpRequest;
import org.jboss.arquillian.warp.impl.client.event.FilterHttpRequest;
import org.jboss.arquillian.warp.impl.client.event.FilterHttpResponse;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.spi.WarpCommons;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class EnrichmentObserver {
    private Logger log = Logger.getLogger("Warp");
    @Inject
    private Event<EnrichHttpRequest> enrichHttpRequest;
    @Inject
    private Event<DeenrichHttpResponse> deenrichHttpResponse;

    public void tryEnrichRequest(@Observes FilterHttpRequest event) {
        Collection<RequestPayload> matchingPayloads;
        HttpRequest request = event.getRequest();
        HttpRequestEnrichmentService enrichmentService = event.getService();
        if (WarpCommons.debugMode()) {
            System.out.println("        (R) " + request.getUri());
        }
        if (!(matchingPayloads = enrichmentService.getMatchingPayloads(request)).isEmpty()) {
            if (matchingPayloads.size() > 1) {
                this.pushException((Exception)new MultipleGroupsPerRequestException(request.getUri()));
            } else {
                this.enrichHttpRequest.fire((Object)new EnrichHttpRequest(request, matchingPayloads.iterator().next(), enrichmentService));
            }
        }
    }

    public void enrichRequest(@Observes EnrichHttpRequest event) {
        HttpRequest request = event.getRequest();
        RequestPayload payload = event.getPayload();
        HttpRequestEnrichmentService enrichmentService = event.getService();
        enrichmentService.enrichRequest(request, payload);
    }

    public void tryDeenrichResponse(@Observes FilterHttpResponse event) {
        HttpResponse response = event.getResponse();
        HttpResponseDeenrichmentService service = event.getService();
        if (service.isEnriched(response)) {
            this.deenrichHttpResponse.fire((Object)new DeenrichHttpResponse(response, service));
        }
    }

    public void deenrichResponse(@Observes DeenrichHttpResponse event) {
        HttpResponse response = event.getResponse();
        HttpResponseDeenrichmentService service = event.getService();
        service.deenrichResponse(response);
    }

    private void pushException(Exception exception) {
        WarpContext warpContext = WarpContextStore.get();
        warpContext.pushException(exception);
    }
}

