/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.warp.client.result.WarpGroupResult;
import org.jboss.arquillian.warp.client.result.WarpResult;
import org.jboss.arquillian.warp.impl.client.execution.SynchronizationPoint;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroup;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;
import org.jboss.arquillian.warp.spi.observer.RequestObserverChainManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarpContextImpl
implements WarpContext {
    private Map<Object, WarpGroup> groups = new HashMap<Object, WarpGroup>();
    private Queue<Exception> exceptions = new ConcurrentLinkedQueue<Exception>();
    private SynchronizationPoint synchronization = new SynchronizationPoint();
    private List<RequestObserverChainManager> observerChainManagers;

    @Override
    public void addGroup(WarpGroup group) {
        this.groups.put(group.getId(), group);
    }

    @Override
    public Collection<WarpGroup> getAllGroups() {
        return this.groups.values();
    }

    @Override
    public WarpGroup getGroup(Object identifier) {
        return this.groups.get(identifier);
    }

    @Override
    public Collection<RequestObserverChainManager> getObserverChainManagers() {
        return this.observerChainManagers;
    }

    @Override
    public TestResult getFirstNonSuccessfulResult() {
        for (WarpGroup group : this.getAllGroups()) {
            TestResult result = group.getFirstNonSuccessfulResult();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void pushResponsePayload(ResponsePayload payload) {
        for (WarpGroup group : this.groups.values()) {
            if (!group.pushResponsePayload(payload)) continue;
            this.synchronization.finishOneResponse();
            return;
        }
        throw new IllegalStateException("There was no group found for given response payload");
    }

    @Override
    public void pushException(Exception exception) {
        this.exceptions.add(exception);
        this.synchronization.finishAll();
    }

    @Override
    public Exception getFirstException() {
        return this.exceptions.peek();
    }

    @Override
    public SynchronizationPoint getSynchronization() {
        return this.synchronization;
    }

    @Override
    public WarpResult getResult() {
        return new WarpResult(){

            public WarpGroupResult getGroup(Object identifier) {
                return (WarpGroupResult)WarpContextImpl.this.groups.get(identifier);
            }
        };
    }

    @Override
    public void initialize(ServiceLoader serviceLoader) {
        this.observerChainManagers = new LinkedList<RequestObserverChainManager>(serviceLoader.all(RequestObserverChainManager.class));
        Collections.sort(this.observerChainManagers, new Comparator<RequestObserverChainManager>(){

            @Override
            public int compare(RequestObserverChainManager o1, RequestObserverChainManager o2) {
                return o1.priotity() - o2.priotity();
            }
        });
    }

    @Override
    public int getExpectedRequestCount() {
        int count = 0;
        for (WarpGroup group : this.getAllGroups()) {
            count += group.getExpectedRequestCount();
        }
        return count;
    }
}

