/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.RequestObserver;
import org.jboss.arquillian.warp.client.execution.GroupExecutionSpecifier;
import org.jboss.arquillian.warp.client.execution.GroupInspectionBuilder;
import org.jboss.arquillian.warp.client.filter.RequestFilter;
import org.jboss.arquillian.warp.client.observer.ObserverBuilder;
import org.jboss.arquillian.warp.impl.client.execution.SecurityActions;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroup;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarpGroupImpl
implements WarpGroup {
    private Object id;
    private RequestObserver observer;
    private GroupInspectionBuilder groupsExecutor;
    private int expectCount = 1;
    private Inspection[] inspections;
    private Map<Long, ResponsePayload> payloads = Collections.synchronizedMap(new LinkedHashMap());

    public WarpGroupImpl(GroupInspectionBuilder groupsExecutor, Object identifier) {
        this.groupsExecutor = groupsExecutor;
        this.id = identifier;
    }

    public GroupExecutionSpecifier observe(RequestObserver what) {
        this.observer = what;
        return this;
    }

    public GroupExecutionSpecifier observe(Class<? extends RequestObserver> observer) {
        this.observer = (RequestObserver)SecurityActions.newInstance(observer.getName(), new Class[0], new Object[0], RequestFilter.class);
        return this;
    }

    public GroupExecutionSpecifier observe(ObserverBuilder<?, ?> observerBuilder) {
        this.observer = observerBuilder.build();
        return this;
    }

    public GroupExecutionSpecifier expectCount(int numberOfRequests) {
        this.expectCount = numberOfRequests;
        return this;
    }

    public GroupInspectionBuilder inspect(Inspection ... inspections) {
        this.addInspections(inspections);
        return this.groupsExecutor;
    }

    @Override
    public void addInspections(Inspection ... inspections) {
        this.inspections = inspections;
    }

    @Override
    public RequestObserver getObserver() {
        return this.observer;
    }

    public <T extends Inspection> T getInspection() {
        return (T)this.payloads.values().iterator().next().getInspections().get(0);
    }

    public <T extends Inspection> T getInspectionForHitNumber(int hitNumber) {
        return (T)this.getInspectionsForHitNumber(hitNumber).get(0);
    }

    public List<Inspection> getInspections() {
        return this.payloads.values().iterator().next().getInspections();
    }

    public List<Inspection> getInspectionsForHitNumber(int hitNumber) {
        ResponsePayload payload = (ResponsePayload)this.payloads.values().toArray()[hitNumber];
        return payload.getInspections();
    }

    public int getHitCount() {
        return this.payloads.size();
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public RequestPayload generateRequestPayload() {
        if (this.payloads.size() + 1 > this.expectCount) {
            throw new IllegalStateException(String.format("There were more requests executed (%s) then expected (%s)", this.payloads.size() + 1, this.expectCount));
        }
        RequestPayload requestPayload = new RequestPayload(this.inspections);
        this.payloads.put(requestPayload.getSerialId(), null);
        return requestPayload;
    }

    @Override
    public boolean pushResponsePayload(ResponsePayload responsePayload) {
        if (this.payloads.containsKey(responsePayload.getSerialId())) {
            this.payloads.put(responsePayload.getSerialId(), responsePayload);
            return true;
        }
        return false;
    }

    @Override
    public TestResult getFirstNonSuccessfulResult() {
        for (ResponsePayload payload : this.payloads.values()) {
            TestResult testResult;
            if (payload == null || (testResult = payload.getTestResult()) == null) continue;
            switch (testResult.getStatus()) {
                case FAILED: {
                    return testResult;
                }
                case SKIPPED: {
                    return testResult;
                }
            }
        }
        return null;
    }

    public String toString() {
        return "WarpGroupImpl [id=" + this.id + "]";
    }

    @Override
    public int getExpectedRequestCount() {
        return this.expectCount;
    }
}

