/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.filter.http;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.arquillian.warp.client.filter.RequestFilter;
import org.jboss.arquillian.warp.client.filter.http.HttpFilterBuilder;
import org.jboss.arquillian.warp.client.filter.http.HttpRequest;
import org.jboss.arquillian.warp.client.filter.matcher.HttpHeaderMatcherBuilder;
import org.jboss.arquillian.warp.client.filter.matcher.MethodMatcherBuilder;
import org.jboss.arquillian.warp.client.filter.matcher.UriMatcherBuilder;
import org.jboss.arquillian.warp.impl.client.filter.http.HttpFilterChainBuilder;
import org.jboss.arquillian.warp.impl.client.filter.matcher.DefaultHttpHeaderMatcherBuilder;
import org.jboss.arquillian.warp.impl.client.filter.matcher.DefaultMethodMatcherBuilder;
import org.jboss.arquillian.warp.impl.client.filter.matcher.DefaultUriMatcherBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpFilterBuilder
implements HttpFilterChainBuilder<HttpFilterBuilder>,
HttpFilterBuilder {
    private RequestFilter<HttpRequest> requestFilter;

    public DefaultHttpFilterBuilder() {
        this(new TrueRequestFilter());
    }

    private DefaultHttpFilterBuilder(RequestFilter<HttpRequest> requestFilter) {
        this.requestFilter = requestFilter;
    }

    public UriMatcherBuilder<HttpFilterBuilder> uri() {
        return new DefaultUriMatcherBuilder(this);
    }

    public MethodMatcherBuilder<HttpFilterBuilder> method() {
        return new DefaultMethodMatcherBuilder(this);
    }

    public HttpHeaderMatcherBuilder<HttpFilterBuilder> header() {
        return new DefaultHttpHeaderMatcherBuilder(this);
    }

    public HttpFilterBuilder copy() {
        return new DefaultHttpFilterBuilder(this.requestFilter);
    }

    public RequestFilter<HttpRequest> build() {
        return this.requestFilter;
    }

    @Override
    public HttpFilterBuilder addFilter(RequestFilter<HttpRequest> filter) {
        this.requestFilter = new ChainHttpRequestFilter(filter, this.requestFilter);
        return this;
    }

    public HttpFilterBuilder index(int count) {
        return this.addFilter(new CountRequestFilter(count));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrueRequestFilter
    implements RequestFilter<HttpRequest> {
        private TrueRequestFilter() {
        }

        public boolean matches(HttpRequest request) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CountRequestFilter
    implements RequestFilter<HttpRequest> {
        private AtomicInteger count;

        public CountRequestFilter(int count) {
            this.count = new AtomicInteger(count);
        }

        public boolean matches(HttpRequest request) {
            return this.count.decrementAndGet() == 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ChainHttpRequestFilter
    implements RequestFilter<HttpRequest> {
        private RequestFilter<HttpRequest> filter;
        private RequestFilter<HttpRequest> previous;

        private ChainHttpRequestFilter(RequestFilter<HttpRequest> filter, RequestFilter<HttpRequest> previous) {
            this.filter = filter;
            this.previous = previous;
        }

        public boolean matches(HttpRequest request) {
            return this.filter.matches((Object)request) && this.previous.matches((Object)request);
        }
    }
}

