/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.filter.matcher;

import java.util.List;
import org.jboss.arquillian.warp.client.filter.RequestFilter;
import org.jboss.arquillian.warp.client.filter.http.HttpFilterBuilder;
import org.jboss.arquillian.warp.client.filter.http.HttpRequest;
import org.jboss.arquillian.warp.client.filter.matcher.HttpHeaderMatcherBuilder;
import org.jboss.arquillian.warp.impl.client.filter.http.HttpFilterChainBuilder;
import org.jboss.arquillian.warp.impl.client.filter.http.NotHttpFilterChainBuilder;
import org.jboss.arquillian.warp.impl.client.filter.matcher.AbstractMatcherFilterBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpHeaderMatcherBuilder
extends AbstractMatcherFilterBuilder
implements HttpHeaderMatcherBuilder<HttpFilterBuilder> {
    public DefaultHttpHeaderMatcherBuilder(HttpFilterChainBuilder<HttpFilterBuilder> filterChainBuilder) {
        super(filterChainBuilder);
    }

    public HttpFilterBuilder equal(final String name, final String value) {
        return this.addFilter(new RequestFilter<HttpRequest>(){

            public boolean matches(HttpRequest request) {
                String headerValue = request.getHeader(name);
                return headerValue != null ? headerValue.equals(value) : value == null;
            }
        });
    }

    public HttpFilterBuilder containsHeader(final String name) {
        return this.addFilter(new RequestFilter<HttpRequest>(){

            public boolean matches(HttpRequest request) {
                return request.containsHeader(name);
            }
        });
    }

    public HttpFilterBuilder containsValue(final String name, String value) {
        return this.addFilter(new RequestFilter<HttpRequest>(){

            public boolean matches(HttpRequest request) {
                List values = request.getHeaders(name);
                for (String val : values) {
                    if (!val.equals(values)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public HttpHeaderMatcherBuilder not() {
        return new DefaultHttpHeaderMatcherBuilder(new NotHttpFilterChainBuilder(this.getFilterChainBuilder()));
    }
}

