/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.proxy;

import java.net.URL;
import java.util.Map;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpRequestEnrichmentFilter;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpRequestEnrichmentService;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpResponseDeenrichmentFilter;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpResponseDeenrichmentService;
import org.jboss.arquillian.warp.impl.client.proxy.ProxyService;
import org.jboss.arquillian.warp.impl.client.proxy.ResponseFilterMap;
import org.littleshoot.proxy.DefaultHttpProxyServer;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpRequestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyService
implements ProxyService<HttpProxyServer> {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    @Override
    public HttpProxyServer startProxy(URL realUrl, URL proxyUrl) {
        HttpRequestEnrichmentFilter requestFilter = (HttpRequestEnrichmentFilter)this.serviceLoader().onlyOne(HttpRequestEnrichmentFilter.class);
        HttpRequestEnrichmentService enrichmentService = (HttpRequestEnrichmentService)this.serviceLoader().onlyOne(HttpRequestEnrichmentService.class);
        requestFilter.initialize(enrichmentService);
        HttpResponseDeenrichmentFilter responseDeenrichmentFilter = (HttpResponseDeenrichmentFilter)this.serviceLoader().onlyOne(HttpResponseDeenrichmentFilter.class);
        responseDeenrichmentFilter.initialize((HttpResponseDeenrichmentService)this.serviceLoader().onlyOne(HttpResponseDeenrichmentService.class));
        String hostPort = realUrl.getHost() + ":" + realUrl.getPort();
        ResponseFilterMap responseFilterMap = new ResponseFilterMap(hostPort, responseDeenrichmentFilter);
        DefaultHttpProxyServer server = new DefaultHttpProxyServer(proxyUrl.getPort(), (Map)responseFilterMap, hostPort, null, (HttpRequestFilter)requestFilter);
        server.start();
        return server;
    }

    @Override
    public void stopProxy(HttpProxyServer proxy) {
        proxy.stop();
    }

    private ServiceLoader serviceLoader() {
        return (ServiceLoader)this.serviceLoader.get();
    }
}

