/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.proxy;

import java.util.Map;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.warp.impl.client.event.RequireProxy;
import org.jboss.arquillian.warp.impl.client.event.StartProxy;
import org.jboss.arquillian.warp.impl.client.proxy.ProxyHolder;
import org.jboss.arquillian.warp.impl.client.proxy.ProxyService;

public class ProxyObserver {
    @Inject
    @SuiteScoped
    private InstanceProducer<ProxyHolder> proxyHolder;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Event<StartProxy> startProxy;

    public void initializeProxies(@Observes BeforeSuite event, ServiceLoader services) {
        this.proxyHolder.set(new ProxyHolder());
    }

    public void finalizeProxies(@Observes AfterSuite event) {
        for (Map.Entry entry : this.proxyHolder().getAllProxies()) {
            this.proxyService().stopProxy(entry.getValue());
        }
    }

    public void requireProxy(@Observes RequireProxy event, ServiceLoader services) {
        Object proxy = this.proxyHolder().getProxy(event.getRealUrl());
        if (proxy == null) {
            this.startProxy.fire((Object)new StartProxy(event));
        }
    }

    public void startProxy(@Observes StartProxy event, ServiceLoader services) {
        Object proxy = this.proxyService().startProxy(event.getRealUrl(), event.getProxyUrl());
        this.proxyHolder().storeProxy(event.getRealUrl(), proxy);
    }

    private ProxyHolder proxyHolder() {
        return (ProxyHolder)this.proxyHolder.get();
    }

    private ProxyService proxyService() {
        return (ProxyService)((ServiceLoader)this.serviceLoader.get()).onlyOne(ProxyService.class);
    }
}

