/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.verification;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.impl.client.event.VerifyResponsePayload;
import org.jboss.arquillian.warp.impl.client.verification.InspectionMethodWasNotInvokedException;
import org.jboss.arquillian.warp.impl.client.verification.SecurityActions;
import org.jboss.arquillian.warp.impl.shared.ExecutedMethod;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;
import org.jboss.arquillian.warp.spi.WarpCommons;

public class ResponsePayloadVerifier {
    public void verifyTestResult(@Observes VerifyResponsePayload event) {
        ResponsePayload responsePayload = event.getResponsePayload();
        if (responsePayload.getTestResult().getStatus() == null) {
            throw new IllegalStateException("ResponsePayload must have TestResult set");
        }
    }

    public void verifyAllLifecycleTestsExecuted(@Observes VerifyResponsePayload event) {
        ResponsePayload responsePayload = event.getResponsePayload();
        if (responsePayload.getTestResult().getStatus() != TestResult.Status.FAILED) {
            Set<ExecutedMethod> executedMethods = responsePayload.getExecutedMethods();
            HashSet<ExecutedMethod> specifiedMethods = new HashSet<ExecutedMethod>();
            for (Inspection inspection : responsePayload.getInspections()) {
                List<Method> methods = SecurityActions.getMethodsWithAnnotation(inspection.getClass());
                for (Method method : methods) {
                    for (Annotation annotation : method.getDeclaredAnnotations()) {
                        Class<? extends Annotation> annotationType = annotation.annotationType();
                        if (!WarpCommons.isWarpLifecycleTest(annotationType)) continue;
                        specifiedMethods.add(new ExecutedMethod(method, annotation));
                    }
                }
            }
            specifiedMethods.removeAll(executedMethods);
            Iterator<Object> i$ = specifiedMethods.iterator();
            if (i$.hasNext()) {
                ExecutedMethod notExecutedMethod = (ExecutedMethod)i$.next();
                throw new InspectionMethodWasNotInvokedException(notExecutedMethod);
            }
        }
    }
}

