/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.enrichment;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.warp.impl.server.enrichment.HttpResponseEnricher;
import org.jboss.arquillian.warp.impl.server.execution.NonWritingResponse;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;
import org.jboss.arquillian.warp.impl.utils.SerializationUtils;

public class DefaultHttpResponseEnricher
implements HttpResponseEnricher {
    private static final Logger log = Logger.getLogger(DefaultHttpResponseEnricher.class.getName());
    @Inject
    private Instance<RequestPayload> requestPayload;
    @Inject
    private Instance<ResponsePayload> responsePayload;
    @Inject
    private Instance<HttpServletResponse> response;
    @Inject
    private Instance<NonWritingResponse> nonWritingResponse;

    public void enrichResponse() {
        try {
            this.enrich((ResponsePayload)this.responsePayload.get(), (HttpServletResponse)this.response.get(), (NonWritingResponse)((Object)this.nonWritingResponse.get()));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Response enrichment failed", e);
            ResponsePayload exceptionPayload = new ResponsePayload(((RequestPayload)this.requestPayload.get()).getSerialId());
            try {
                this.enrich(exceptionPayload, (HttpServletResponse)this.response.get(), (NonWritingResponse)((Object)this.nonWritingResponse.get()));
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "Response enrichment failed to attach enrichment failure", ex);
            }
        }
    }

    private void enrich(ResponsePayload payload, HttpServletResponse response, NonWritingResponse nonWritingResponse) throws IOException {
        Integer originalLength = nonWritingResponse.getContentLength();
        payload.setStatus(nonWritingResponse.getStatus());
        payload.setHeaders(nonWritingResponse.getHeaders());
        String enrichment = SerializationUtils.serializeToBase64(payload);
        response.setHeader("X-Arq-Enrichment-Response", Integer.toString(enrichment.length()));
        if (originalLength != null) {
            int enrichmentLength = enrichment.length();
            int newLength = originalLength + enrichmentLength;
            nonWritingResponse.setContentLength(newLength);
        }
        response.setStatus(200);
        ServletOutputStream servletOutputStream = response.getOutputStream();
        servletOutputStream.write(enrichment.getBytes());
        nonWritingResponse.finallyWriteAndClose(servletOutputStream);
    }
}

