/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.execution;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.arquillian.warp.impl.server.execution.NonWritingPrintWriter;
import org.jboss.arquillian.warp.impl.server.execution.NonWritingServletOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonWritingResponse
extends HttpServletResponseWrapper {
    private Integer contentLength = null;
    private Integer status;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private NonWritingServletOutputStream stream;
    private NonWritingPrintWriter writer;

    public NonWritingResponse(HttpServletResponse response) {
        super(response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stream == null) {
            this.stream = new NonWritingServletOutputStream();
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = NonWritingPrintWriter.newInstance();
        }
        return this.writer;
    }

    public void setContentLength(int len) {
        this.contentLength = len;
    }

    public Integer getContentLength() {
        return this.contentLength;
    }

    public void sendRedirect(String location) throws IOException {
        this.setStatus(302);
        this.setHeader("Location", location);
    }

    public int getStatus() {
        return this.status == null ? 200 : this.status;
    }

    public void setHeader(String name, String value) {
        LinkedList<String> list = new LinkedList<String>();
        this.headers.put(name, list);
        list.add(value);
    }

    public void addHeader(String name, String value) {
        if (this.headers.get(name) == null) {
            this.setHeader(name, value);
        } else {
            this.headers.get(name).add(value);
        }
    }

    public String getHeader(String name) {
        List<String> list = this.headers.get(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public void setStatus(int sc) {
        this.status = sc;
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public Collection<String> getHeaders(String name) {
        return super.getHeaders(name);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public NonWritingServletOutputStream getNonWritingServletOutputStream() {
        return this.stream;
    }

    public NonWritingPrintWriter getNonWritingPrintWriter() {
        return this.writer;
    }

    public void finallyWriteAndClose(ServletOutputStream delegateStream) throws IOException {
        if (this.contentLength != null) {
            super.setContentLength(this.contentLength.intValue());
        }
        if (this.writer != null) {
            this.writer.finallyWriteAndClose(delegateStream);
        }
        if (this.stream != null) {
            this.stream.finallyWriteAndClose(delegateStream);
        }
    }
}

