/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.inspection;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.warp.Inspection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectionRegistry {
    private Set<Inspection> inspections = new LinkedHashSet<Inspection>(1);

    public void registerInspections(Inspection ... inspections) {
        this.registerInspections(Arrays.asList(inspections));
    }

    public void registerInspections(Collection<Inspection> inspections) {
        this.validateNotNull(inspections);
        this.inspections.addAll(inspections);
    }

    public void unregisterInspections(Inspection ... inspections) {
        this.unregisterInspections(Arrays.asList(inspections));
    }

    public void unregisterInspections(Collection<Inspection> inspections) {
        this.validateNotNull(inspections);
        this.inspections.removeAll(inspections);
    }

    public Collection<Inspection> getInspections() {
        return this.inspections;
    }

    private void validateNotNull(Collection<Inspection> inspections) {
        for (Inspection inspection : inspections) {
            Validate.notNull((Object)inspection, (String)"inspection must not be null");
        }
    }
}

