/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.server.test;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.Test;
import org.jboss.arquillian.warp.Inspection;
import org.jboss.arquillian.warp.impl.server.inspection.InspectionRegistry;
import org.jboss.arquillian.warp.impl.server.test.LifecycleMethodExecutor;
import org.jboss.arquillian.warp.impl.server.test.SecurityActions;
import org.jboss.arquillian.warp.spi.WarpCommons;
import org.jboss.arquillian.warp.spi.WarpLifecycleEvent;
import org.jboss.arquillian.warp.spi.WarpLifecycleTest;

public class LifecycleTestDriver {
    @Inject
    private Instance<InspectionRegistry> registry;
    @Inject
    private Event<Before> before;
    @Inject
    private Event<After> after;
    @Inject
    private Event<Test> test;

    public void fireTest(@Observes WarpLifecycleEvent event) {
        for (Inspection inspection : this.registry().getInspections()) {
            Annotation annotation = event.getAnnotation();
            if (annotation == null || !WarpCommons.isWarpLifecycleTest(annotation.annotationType())) {
                throw new IllegalStateException("Warp lifecycle event must contain annotation marked with @" + WarpLifecycleTest.class.getSimpleName());
            }
            List<Method> methods = SecurityActions.getMethodsWithAnnotation(inspection.getClass(), annotation);
            for (Method testMethod : methods) {
                this.executeTest(inspection, testMethod, annotation);
            }
        }
    }

    private void executeTest(Object inspection, Method method, Annotation annotation) {
        this.before.fire((Object)new Before(inspection, method));
        this.test.fire((Object)new Test((TestMethodExecutor)new LifecycleMethodExecutor(inspection, method, annotation)));
        this.after.fire((Object)new After(inspection, method));
    }

    private InspectionRegistry registry() {
        return (InspectionRegistry)this.registry.get();
    }
}

