/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.shared;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.warp.impl.shared.SerializedAnnotation;
import org.jboss.arquillian.warp.impl.shared.SerializedMethod;

public class ExecutedMethod
implements Externalizable {
    private Method method;
    private Annotation annotation;

    public ExecutedMethod() {
    }

    public ExecutedMethod(Method method, Annotation annotation) {
        Validate.notNull((Object)method, (String)"method must not be null");
        Validate.notNull((Object)annotation, (String)"annotation must not be null");
        this.method = method;
        this.annotation = annotation;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(Annotation annotation) {
        this.annotation = annotation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutedMethod other = (ExecutedMethod)obj;
        if (this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(new SerializedMethod(this.method));
        out.writeObject(new SerializedAnnotation(this.annotation));
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.method = ((SerializedMethod)in.readObject()).getMethod();
        this.annotation = ((SerializedAnnotation)in.readObject()).getAnnotation();
    }
}

