/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.shared;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.warp.impl.utils.AnnotationInstanceProvider;

public class SerializedAnnotation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Class<? extends Annotation> annotationType;
    private Map<String, Serializable> values = new HashMap<String, Serializable>();

    public SerializedAnnotation(Annotation annotation) {
        this.annotationType = annotation.annotationType();
        List<Method> declaredMethods = Arrays.asList(this.annotationType.getDeclaredMethods());
        Collections.sort(declaredMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Method method : declaredMethods) {
            try {
                Serializable value = (Serializable)method.invoke((Object)annotation, new Object[0]);
                this.values.put(method.getName(), value);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public Annotation getAnnotation() {
        try {
            return AnnotationInstanceProvider.get(this.annotationType, this.values);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

