/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.warp.impl.utils.NullMemberException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotationInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 4801508041776645033L;
    private final Map<String, Object> valueMap = new HashMap<String, Object>();
    private final Class<? extends Annotation> annotationType;
    private final Method[] members;

    AnnotationInvocationHandler(Map<String, ?> values, Class<? extends Annotation> annotationType) {
        this.valueMap.putAll(values);
        this.annotationType = annotationType;
        for (Method m : this.members = annotationType.getDeclaredMethods()) {
            Object value = this.valueMap.get(m.getName());
            if (value != null) continue;
            value = m.getDefaultValue();
            if (value == null) {
                throw new NullMemberException(annotationType, m, "Error creating annotation @" + annotationType.getName() + " member " + m.getName() + " was null and does not provide a default value");
            }
            this.valueMap.put(m.getName(), value);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals")) {
            return this.equals(args[0]);
        }
        if (method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        if (method.getName().equals("annotationType")) {
            return this.annotationType;
        }
        Object val = this.valueMap.get(method.getName());
        Class<?> r = method.getReturnType();
        val = this.performTypeCoercion(val, r);
        return val;
    }

    private Object performTypeCoercion(Object val, Class<?> type) {
        if (Integer.class.isAssignableFrom(type) || type == Integer.TYPE) {
            return ((Number)val).intValue();
        }
        if (Long.class.isAssignableFrom(type) || type == Long.TYPE) {
            return ((Number)val).longValue();
        }
        if (Short.class.isAssignableFrom(type) || type == Short.TYPE) {
            return ((Number)val).shortValue();
        }
        if (Byte.class.isAssignableFrom(type) || type == Byte.TYPE) {
            return ((Number)val).byteValue();
        }
        if (Double.class.isAssignableFrom(type) || type == Double.TYPE) {
            return ((Number)val).doubleValue();
        }
        if (Float.class.isAssignableFrom(type) || type == Float.TYPE) {
            return Float.valueOf(((Number)val).floatValue());
        }
        if ((Character.class.isAssignableFrom(type) || type == Character.TYPE) && String.class.isAssignableFrom(val.getClass())) {
            return Character.valueOf(val.toString().charAt(0));
        }
        return val;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append('@').append(this.annotationType.getName()).append('(');
        for (int i = 0; i < this.members.length; ++i) {
            int j;
            string.append(this.members[i].getName()).append('=');
            Object value = this.performTypeCoercion(this.valueMap.get(this.members[i].getName()), this.members[i].getReturnType());
            if (value instanceof boolean[]) {
                this.appendInBraces(string, Arrays.toString((boolean[])value));
            } else if (value instanceof byte[]) {
                this.appendInBraces(string, Arrays.toString((byte[])value));
            } else if (value instanceof short[]) {
                this.appendInBraces(string, Arrays.toString((short[])value));
            } else if (value instanceof int[]) {
                this.appendInBraces(string, Arrays.toString((int[])value));
            } else if (value instanceof long[]) {
                this.appendInBraces(string, Arrays.toString((long[])value));
            } else if (value instanceof float[]) {
                this.appendInBraces(string, Arrays.toString((float[])value));
            } else if (value instanceof double[]) {
                this.appendInBraces(string, Arrays.toString((double[])value));
            } else if (value instanceof char[]) {
                this.appendInBraces(string, Arrays.toString((char[])value));
            } else if (value instanceof String[]) {
                String[] strings = (String[])value;
                Object[] quoted = new String[strings.length];
                for (j = 0; j < strings.length; ++j) {
                    quoted[j] = "\"" + strings[j] + "\"";
                }
                this.appendInBraces(string, Arrays.toString(quoted));
            } else if (value instanceof Class[]) {
                Class[] classes = (Class[])value;
                Object[] names = new String[classes.length];
                for (j = 0; j < classes.length; ++j) {
                    names[j] = classes[j].getName() + ".class";
                }
                this.appendInBraces(string, Arrays.toString(names));
            } else if (value instanceof Object[]) {
                this.appendInBraces(string, Arrays.toString((Object[])value));
            } else if (value instanceof String) {
                string.append('\"').append(value).append('\"');
            } else if (value instanceof Class) {
                string.append(((Class)value).getName()).append(".class");
            } else {
                string.append(value);
            }
            if (i >= this.members.length - 1) continue;
            string.append(", ");
        }
        return string.append(')').toString();
    }

    private void appendInBraces(StringBuilder buf, String s) {
        buf.append('{').append(s.substring(1, s.length() - 1)).append('}');
    }

    public boolean equals(Object other) {
        Annotation that;
        if (other instanceof Annotation && this.annotationType.equals((that = (Annotation)other).annotationType())) {
            for (Method member : this.members) {
                Object thisValue = this.performTypeCoercion(this.valueMap.get(member.getName()), member.getReturnType());
                Object thatValue = AnnotationInvocationHandler.invoke(member, that);
                if (!(thisValue instanceof byte[] && thatValue instanceof byte[] ? !Arrays.equals((byte[])thisValue, (byte[])thatValue) : (thisValue instanceof short[] && thatValue instanceof short[] ? !Arrays.equals((short[])thisValue, (short[])thatValue) : (thisValue instanceof int[] && thatValue instanceof int[] ? !Arrays.equals((int[])thisValue, (int[])thatValue) : (thisValue instanceof long[] && thatValue instanceof long[] ? !Arrays.equals((long[])thisValue, (long[])thatValue) : (thisValue instanceof float[] && thatValue instanceof float[] ? !Arrays.equals((float[])thisValue, (float[])thatValue) : (thisValue instanceof double[] && thatValue instanceof double[] ? !Arrays.equals((double[])thisValue, (double[])thatValue) : (thisValue instanceof char[] && thatValue instanceof char[] ? !Arrays.equals((char[])thisValue, (char[])thatValue) : (thisValue instanceof boolean[] && thatValue instanceof boolean[] ? !Arrays.equals((boolean[])thisValue, (boolean[])thatValue) : (thisValue instanceof Object[] && thatValue instanceof Object[] ? !Arrays.equals((Object[])thisValue, (Object[])thatValue) : !thisValue.equals(thatValue))))))))))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Method member : this.members) {
            int memberNameHashCode = 127 * member.getName().hashCode();
            Object value = this.performTypeCoercion(this.valueMap.get(member.getName()), member.getReturnType());
            int memberValueHashCode = value instanceof boolean[] ? Arrays.hashCode((boolean[])value) : (value instanceof short[] ? Arrays.hashCode((short[])value) : (value instanceof int[] ? Arrays.hashCode((int[])value) : (value instanceof long[] ? Arrays.hashCode((long[])value) : (value instanceof float[] ? Arrays.hashCode((float[])value) : (value instanceof double[] ? Arrays.hashCode((double[])value) : (value instanceof byte[] ? Arrays.hashCode((byte[])value) : (value instanceof char[] ? Arrays.hashCode((char[])value) : (value instanceof Object[] ? Arrays.hashCode((Object[])value) : value.hashCode()))))))));
            hashCode += memberNameHashCode ^ memberValueHashCode;
        }
        return hashCode;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.valueMap, this.annotationType);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("Must use SerializationProxy");
    }

    private static Object invoke(Method method, Object instance) {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error checking value of member method " + method.getName() + " on " + method.getDeclaringClass(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy {
        private final Map<String, ?> valueMap;
        private final Class<? extends Annotation> annotationType;

        private SerializationProxy(Map<String, ?> valueMap, Class<? extends Annotation> annotationType) {
            this.valueMap = valueMap;
            this.annotationType = annotationType;
        }

        private Object readResolve() throws ObjectStreamException {
            return new AnnotationInvocationHandler(this.valueMap, this.annotationType);
        }
    }
}

