/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jboss.arquillian.warp.impl.utils.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationUtils {
    public static byte[] serializeToBytes(Serializable object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends Serializable> T deserializeFromBytes(byte[] serializedObject) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedObject);
            ObjectInputStream ois = new ObjectInputStream(bais);
            return (T)((Serializable)ois.readObject());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String serializeToBase64(Serializable object) {
        byte[] serialized = SerializationUtils.serializeToBytes(object);
        return new String(Base64.encodeBase64(serialized));
    }

    public static <T extends Serializable> T deserializeFromBase64(String serializedObject) {
        byte[] bytes = Base64.decodeBase64(serializedObject);
        return SerializationUtils.deserializeFromBytes(bytes);
    }
}

