/**
 * JBoss, Home of Professional Open Source
 * Copyright 2013, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.arquillian.warp.impl.server.manager;

import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.EventContext;
import org.jboss.arquillian.core.spi.context.ApplicationContext;
import org.jboss.arquillian.warp.impl.server.event.ActivateManager;
import org.jboss.arquillian.warp.impl.server.event.PassivateManager;

/**
 *
 * Activates and deactivates {@link ApplicationContext}
 *
 * @author Aris Tzoumas
 *
 */
public class ManagerActivationObserver {

    public void activateApplicationContext(@Observes(precedence = 100) EventContext<ActivateManager> context) {
        context.getEvent().getManager().getContext(ApplicationContext.class).activate();
        context.proceed();
    }

    public void deactivateApplicationContext(@Observes(precedence = 100) EventContext<PassivateManager> context) {
        try {
            context.proceed();
        } finally {
            context.getEvent().getManager().getContext(ApplicationContext.class).deactivate();
        }
    }
}
