/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.commandBus;

import java.lang.reflect.Method;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.spi.annotation.TestScoped;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.TestEvent;
import org.jboss.arquillian.warp.impl.client.commandBus.CommandBusOnClient;
import org.jboss.arquillian.warp.spi.WarpCommons;

public class CommandBusObserver {
    @Inject
    private Event<StartBus> startBus;
    @Inject
    private Event<StopBus> stopBus;
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<Injector> injector;
    @Inject
    @TestScoped
    private InstanceProducer<CommandBusOnClient> commandBusInst;

    void beforeTest(@Observes(precedence=500) Before event) {
        Class<?> testClass = event.getTestInstance().getClass();
        if (WarpCommons.isWarpTest(testClass)) {
            this.startBus.fire((Object)new StartBus((TestEvent)event));
        }
    }

    void afterTest(@Observes(precedence=-500) After event) {
        Class<?> testClass = event.getTestInstance().getClass();
        if (WarpCommons.isWarpTest(testClass)) {
            this.stopBus.fire((Object)new StopBus((TestEvent)event));
        }
    }

    void startEventBus(@Observes StartBus event) throws Exception {
        CommandBusOnClient bus = new CommandBusOnClient();
        ((Injector)this.injector.get()).inject((Object)bus);
        this.commandBusInst.set((Object)bus);
        bus.startBus(event);
    }

    void stopEventBus(@Observes StopBus event) {
        CommandBusOnClient bus = (CommandBusOnClient)this.commandBusInst.get();
        bus.stopBus();
    }

    public static abstract class BusEvent {
        private Object testInstance;
        private Method testMethod;

        public BusEvent(TestEvent event) {
            this.testInstance = event.getTestInstance();
            this.testMethod = event.getTestMethod();
        }

        public Object getTestInstance() {
            return this.testInstance;
        }

        public Method getTestMethod() {
            return this.testMethod;
        }
    }

    public static final class StopBus
    extends BusEvent {
        public StopBus(TestEvent event) {
            super(event);
        }
    }

    public static final class StartBus
    extends BusEvent {
        public StartBus(TestEvent event) {
            super(event);
        }
    }
}

