/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.deployment;

import org.jboss.arquillian.container.spi.client.deployment.Deployment;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentScenario;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.warp.spi.WarpCommons;

public class DeploymentValidator {
    @Inject
    private Instance<TestClass> testClass;

    public void verifyWarpDeployment(@Observes DeploymentScenario deploymentScenario) {
        if (WarpCommons.isWarpTest((Class)((TestClass)this.testClass.get()).getJavaClass())) {
            for (Deployment deployment : deploymentScenario.deployments()) {
                DeploymentDescription description = deployment.getDescription();
                if (description.testable()) continue;
                throw new IllegalArgumentException("Warp deployments must be testable: " + ((TestClass)this.testClass.get()).getJavaClass() + " - check that you have @Deployment(testable=true)");
            }
        }
    }
}

