/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import io.netty.handler.codec.http.HttpRequest;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.RequestObserver;
import org.jboss.arquillian.warp.client.filter.Request;
import org.jboss.arquillian.warp.client.filter.RequestFilter;
import org.jboss.arquillian.warp.client.filter.http.HttpRequestFilter;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpRequestEnrichmentService;
import org.jboss.arquillian.warp.impl.client.execution.HttpRequestWrapper;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroup;
import org.jboss.arquillian.warp.impl.server.inspection.PayloadRegistry;
import org.jboss.arquillian.warp.impl.shared.RequestPayload;
import org.jboss.arquillian.warp.impl.shared.command.Command;
import org.jboss.arquillian.warp.impl.shared.command.CommandService;
import org.jboss.arquillian.warp.impl.utils.Rethrow;
import org.jboss.arquillian.warp.impl.utils.SerializationUtils;
import org.jboss.arquillian.warp.spi.WarpCommons;
import org.jboss.arquillian.warp.spi.observer.RequestObserverChainManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpRequestEnrichmentService
implements HttpRequestEnrichmentService {
    private Logger log = Logger.getLogger("Warp");
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    @Override
    public Collection<RequestPayload> getMatchingPayloads(org.jboss.arquillian.warp.client.filter.http.HttpRequest request) {
        Collection<WarpGroup> groups = this.warpContext().getAllGroups();
        LinkedList<RequestPayload> payloads = new LinkedList<RequestPayload>();
        block0: for (WarpGroup group : groups) {
            LinkedList<RequestObserver> observers = new LinkedList<RequestObserver>();
            if (group.getObserver() != null) {
                observers.add(group.getObserver());
            }
            Collection<RequestObserverChainManager> observerChainManagers = this.warpContext().getObserverChainManagers();
            for (RequestObserverChainManager chainManager : observerChainManagers) {
                chainManager.manageObserverChain(observers, HttpRequestFilter.class);
            }
            for (RequestObserver observer : observers) {
                if (!this.isHttpFilter(observer)) {
                    this.log.warning("One of the defined observers (" + observer.toString() + ") of class " + observer.getClass() + " doesn't match expected type (" + HttpRequestFilter.class + ") - continuing without processing this request group");
                    continue block0;
                }
                RequestFilter filter = (RequestFilter)observer;
                if (filter.matches((Object)request)) continue;
                continue block0;
            }
            payloads.add(group.generateRequestPayload((Request)request));
        }
        return payloads;
    }

    @Override
    public void enrichRequest(org.jboss.arquillian.warp.client.filter.http.HttpRequest request, RequestPayload payload) {
        if (WarpCommons.debugMode()) {
            System.out.println("                (W) " + request.getUri());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Warp request: " + request.getUri());
        }
        try {
            String requestEnrichment = SerializationUtils.serializeToBase64(payload);
            long serialId = payload.getSerialId();
            this.remoteOperationService().execute(new RegisterPayloadRemotely(requestEnrichment));
            HttpRequest nettyHttpRequest = ((HttpRequestWrapper)request).unwrap();
            nettyHttpRequest.headers().set("X-Arq-Enrichment-Request", Arrays.asList(Long.toString(serialId)));
        }
        catch (Throwable originalException) {
            Throwable cause = Rethrow.getOriginalCause(originalException);
            ClientWarpExecutionException explainingException = new ClientWarpExecutionException("enriching request failed; caused by:\n" + cause.getClass().getName() + ": " + cause.getMessage(), originalException);
            this.warpContext().pushException((Exception)explainingException);
        }
    }

    private boolean isHttpFilter(RequestObserver observer) {
        return observer instanceof RequestFilter && this.isType((RequestFilter<?>)((RequestFilter)observer), (Type)((Object)org.jboss.arquillian.warp.client.filter.http.HttpRequest.class));
    }

    private boolean isType(RequestFilter<?> filter, Type expectedType) {
        Type[] interfaces;
        for (Type type : interfaces = filter.getClass().getGenericInterfaces()) {
            ParameterizedType parametrizedType;
            if (!(type instanceof ParameterizedType) || (parametrizedType = (ParameterizedType)type).getRawType() != RequestFilter.class) continue;
            return parametrizedType.getActualTypeArguments()[0] == expectedType;
        }
        return false;
    }

    private WarpContext warpContext() {
        return WarpContextStore.get();
    }

    private CommandService remoteOperationService() {
        return (CommandService)((ServiceLoader)this.serviceLoader.get()).onlyOne(CommandService.class);
    }

    public static class RegisterPayloadRemotely
    implements Command {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient Instance<PayloadRegistry> registry;
        private String requestPayload;

        public RegisterPayloadRemotely(String requestPayload) {
            this.requestPayload = requestPayload;
        }

        public void perform() {
            RequestPayload payload = (RequestPayload)SerializationUtils.deserializeFromBase64(this.requestPayload);
            ((PayloadRegistry)this.registry.get()).registerRequestPayload(payload);
        }
    }
}

