/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.exception.ServerWarpExecutionException;
import org.jboss.arquillian.warp.exception.WarpExecutionException;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpResponseDeenrichmentService;
import org.jboss.arquillian.warp.impl.client.event.VerifyResponsePayload;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.server.inspection.PayloadRegistry;
import org.jboss.arquillian.warp.impl.shared.ResponsePayload;
import org.jboss.arquillian.warp.impl.shared.command.Command;
import org.jboss.arquillian.warp.impl.shared.command.CommandService;
import org.jboss.arquillian.warp.impl.utils.SerializationUtils;

public class DefaultResponseDeenrichmentService
implements HttpResponseDeenrichmentService {
    private final Logger log = Logger.getLogger(HttpResponseDeenrichmentService.class.getName());
    @Inject
    private Event<VerifyResponsePayload> verifyResponsePayload;
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public boolean isEnriched(HttpRequest request, HttpResponse response) {
        Long serialId = this.getSerialId(request);
        return serialId != null;
    }

    public void deenrichResponse(HttpRequest request, HttpResponse response) {
        WarpContext context = WarpContextStore.get();
        try {
            long serialId = this.getSerialId(request);
            ResponsePayload payload = this.retrieveResponsePayload(serialId);
            if (context != null) {
                this.verifyResponsePayload.fire((Object)new VerifyResponsePayload(payload));
                context.pushResponsePayload(payload);
            }
        }
        catch (Exception originalException) {
            if (context != null) {
                Object explainingException = originalException instanceof WarpExecutionException ? (WarpExecutionException)originalException : new ClientWarpExecutionException("deenriching response failed: " + originalException.getMessage(), (Throwable)originalException);
                context.pushException((Exception)explainingException);
            }
            this.log.log(Level.WARNING, "Unable to push exception to WarpContext", originalException);
        }
    }

    private ResponsePayload retrieveResponsePayload(long serialId) throws InterruptedException {
        PayloadRegistry.ResponsePayloadWasNeverRegistered last = null;
        for (int i = 0; i <= 10; ++i) {
            try {
                RetrievePayloadFromServer result = this.remoteOperationService().execute(new RetrievePayloadFromServer(serialId));
                return result.getResponsePayload();
            }
            catch (PayloadRegistry.ResponsePayloadWasNeverRegistered e) {
                Thread.sleep(300L);
                last = e;
                continue;
            }
            catch (Throwable e) {
                throw new ServerWarpExecutionException("failed to retrieve a response payloade: " + e.getMessage(), e);
            }
        }
        throw last;
    }

    private Long getSerialId(HttpRequest request) {
        String header = request.headers().get("X-Arq-Enrichment-Request");
        if (header == null || header.isEmpty()) {
            return null;
        }
        return Long.valueOf(header);
    }

    private CommandService remoteOperationService() {
        return (CommandService)((ServiceLoader)this.serviceLoader.get()).onlyOne(CommandService.class);
    }

    public static class RetrievePayloadFromServer
    implements Command {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient Instance<PayloadRegistry> registry;
        private long serialId;
        private byte[] serializedPayload;

        public RetrievePayloadFromServer(long serialId) {
            this.serialId = serialId;
        }

        public ResponsePayload getResponsePayload() {
            return (ResponsePayload)SerializationUtils.deserializeFromBytes(this.serializedPayload);
        }

        public void perform() {
            ResponsePayload responsePayload = ((PayloadRegistry)this.registry.get()).retrieveResponsePayload(this.serialId);
            this.serializedPayload = SerializationUtils.serializeToBytes(responsePayload);
        }
    }
}

