/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.impl.client.enrichment.HttpResponseTransformationService;
import org.jboss.arquillian.warp.impl.client.proxy.RealURLToProxyURLMapping;

public class DefaultResponseTransformationService
implements HttpResponseTransformationService {
    @Inject
    private Instance<RealURLToProxyURLMapping> realToProxyURLMappingInst;
    @Inject
    private Instance<ServiceLoader> services;

    public HttpResponse transformResponse(HttpRequest request, HttpResponse response) {
        FullHttpResponse fullResponse;
        String contentTypeHeader;
        if (response instanceof FullHttpResponse && (contentTypeHeader = (fullResponse = (FullHttpResponse)response).headers().get("Content-Type")) != null && contentTypeHeader.startsWith("text/")) {
            ContentType contentType = ContentType.parse((String)contentTypeHeader);
            Charset charset = contentType.getCharset();
            ByteBuf content = fullResponse.content();
            byte[] data = new byte[content.readableBytes()];
            content.readBytes(data);
            String responseToTransform = this.createStringFromData(data, charset);
            RealURLToProxyURLMapping mapping = (RealURLToProxyURLMapping)this.realToProxyURLMappingInst.get();
            for (Map.Entry<URL, URL> entry : mapping.asMap().entrySet()) {
                String realUrl = entry.getKey().toExternalForm();
                String proxyUrl = entry.getValue().toExternalForm();
                int urlStart = responseToTransform.indexOf(realUrl);
                if (urlStart <= 0) continue;
                responseToTransform = responseToTransform.replace(realUrl, proxyUrl);
            }
            byte[] bytes = this.createDataFromString(responseToTransform, charset);
            ByteBuf transformedContent = Unpooled.buffer((int)bytes.length);
            transformedContent.writeBytes(bytes);
            DefaultFullHttpResponse transformedResponse = new DefaultFullHttpResponse(fullResponse.getProtocolVersion(), fullResponse.getStatus(), transformedContent);
            transformedResponse.headers().set(fullResponse.headers());
            HttpHeaders.setContentLength((HttpMessage)transformedResponse, (long)bytes.length);
            return transformedResponse;
        }
        return response;
    }

    private String createStringFromData(byte[] data, Charset charset) {
        return charset == null ? new String(data) : new String(data, charset);
    }

    private byte[] createDataFromString(String string, Charset charset) {
        return charset == null ? string.getBytes() : string.getBytes(charset);
    }
}

