/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.arquillian.warp.impl.client.execution.WarpContextStore;
import org.jboss.arquillian.warp.impl.client.execution.WarpSynchronizationException;

public class SynchronizationPoint {
    private static final long THREAD_SLEEP = 50L;
    private final long WAIT_TIMEOUT_MILISECONDS = Long.parseLong(System.getProperty("arquillian.warp.synchronization.timeout", "5000"));
    private final long NUMBER_OF_WAIT_LOOPS = this.WAIT_TIMEOUT_MILISECONDS / 50L;
    private final AtomicBoolean enrichmentAdvertised = new AtomicBoolean(false);
    private final AtomicBoolean enrichmentClosed = new AtomicBoolean(false);
    private CountDownLatch responseFinished;

    void advertise() {
        this.enrichmentAdvertised.set(true);
    }

    void close(int expectedRequestCount) {
        this.responseFinished = new CountDownLatch(expectedRequestCount);
        this.enrichmentClosed.set(true);
    }

    void finishOneResponse() {
        this.responseFinished.countDown();
    }

    void finishAll() {
        for (long i = this.responseFinished.getCount(); i >= 0L; --i) {
            this.responseFinished.countDown();
        }
    }

    private boolean isEnrichmentAdvertised() {
        return this.enrichmentAdvertised.get();
    }

    private boolean isEnrichmentClosed() {
        return this.enrichmentClosed.get();
    }

    boolean isWaitingForRequests() {
        return this.isEnrichmentAdvertised();
    }

    boolean isWaitingForEnriching() {
        return this.isEnrichmentAdvertised() && !this.isEnrichmentClosed();
    }

    boolean isWaitingForResponses() {
        return this.isEnrichmentAdvertised() && this.isEnrichmentClosed() && this.responseFinished.getCount() > 0L;
    }

    void awaitRequests() {
        if (!this.isWaitingForEnriching()) {
            return;
        }
        int i = 0;
        while ((long)i < this.NUMBER_OF_WAIT_LOOPS) {
            try {
                Thread.sleep(50L);
                if (!this.isEnrichmentAdvertised()) {
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            ++i;
        }
        throw new SettingRequestTimeoutException();
    }

    void awaitResponses() {
        try {
            boolean finishedNicely = this.responseFinished.await(this.WAIT_TIMEOUT_MILISECONDS, TimeUnit.MILLISECONDS);
            if (!finishedNicely) {
                throw new WarpSynchronizationException(WarpContextStore.get());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class RequestEnrichmentAlreadySetException
    extends RuntimeException {
        private static final long serialVersionUID = 8333157142743791135L;
    }

    public static class SettingRequestTimeoutException
    extends RuntimeException {
        private static final long serialVersionUID = -6743564150233628034L;
    }
}

