/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import org.jboss.arquillian.warp.client.filter.Request;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroup;

public class TooManyRequestsException
extends ClientWarpExecutionException {
    private static final long serialVersionUID = -9086096239081792164L;
    private String message;

    public TooManyRequestsException(WarpGroup group, Request request) {
        this.message = new MessageGenerator(group, request).generateMessage();
    }

    public String getMessage() {
        return this.message;
    }

    private static class MessageGenerator {
        private WarpGroup group;
        private Request request;
        private StringBuilder message = new StringBuilder();

        public MessageGenerator(WarpGroup context, Request request) {
            this.group = context;
            this.request = request;
        }

        public String generateMessage() {
            this.generalIntroMessage();
            this.messageListingRequests();
            this.messageForObserver();
            this.generalAdviceForDebugging();
            return this.message.toString();
        }

        private void messageForObserver() {
            this.message.append("Observer: ");
            this.message.append(this.group.getObserver());
            this.message.append("\n\n");
        }

        private void generalIntroMessage() {
            this.message.append(String.format("There were more requests observed (%s) then expected (%s).\n\n", 1 + this.group.getHitCount(), this.group.getExpectedRequestCount()));
        }

        private void messageListingRequests() {
            for (Request request : this.group.getAllRequests()) {
                this.messageForRequest(request);
            }
            this.messageForRequest(this.request);
            this.message.append("\n");
        }

        private void messageForRequest(Request request) {
            this.message.append(" - ");
            this.message.append(request);
            this.message.append("\n");
        }

        private void generalAdviceForDebugging() {
            this.message.append("If Warp observes wrong request, use observe(...) method to select appropriate request which should be enriched instead.\n");
            this.message.append("You can also use method observe(request().index(1)) to select just first from those requests or simply use single-request execution API (Warp.initiate(a).observe(o).inspect(i)).\n");
            this.message.append("Otherwise check the server-side log and enable Arquillian debugging mode on both, test and server VM by passing -Darquillian.debug=true.\n");
        }
    }
}

