/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.util.concurrent.atomic.AtomicReference;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;

public class WarpContextStore {
    private static final AtomicReference<WarpContext> reference = new AtomicReference();

    static void set(WarpContext warpContext) {
        Validate.notNull((Object)warpContext, (String)"WarpContext for setting to store can't be null");
        try {
            while (!reference.compareAndSet(null, warpContext)) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    static void reset() {
        WarpContext context = reference.get();
        Validate.notNull((Object)context, (String)"WarpContext in store can't be null when resetting");
        reference.compareAndSet(context, null);
    }

    static WarpContext get() {
        return reference.get();
    }
}

