/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.Activity;
import org.jboss.arquillian.warp.impl.client.event.AdvertiseEnrichment;
import org.jboss.arquillian.warp.impl.client.event.AwaitResponse;
import org.jboss.arquillian.warp.impl.client.event.CleanEnrichment;
import org.jboss.arquillian.warp.impl.client.event.ExecuteWarp;
import org.jboss.arquillian.warp.impl.client.event.FinishEnrichment;
import org.jboss.arquillian.warp.impl.client.execution.ExecutionSynchronizer;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpExecutor;

public class WarpExecutionObserver {
    @Inject
    private Instance<ServiceLoader> services;
    @Inject
    private Instance<WarpContext> warpContext;

    public void executeWarp(@Observes ExecuteWarp event) throws Exception {
        try {
            this.warpExecutor().execute(event.getActivity(), event.getWarpContext());
        }
        catch (Exception e) {
            ((WarpContext)this.warpContext.get()).pushException(e);
        }
    }

    public void advertiseEnrichment(@Observes AdvertiseEnrichment event) {
        this.inspectionSynchronizer().advertise();
    }

    public void finishEnrichment(@Observes FinishEnrichment event) {
        this.inspectionSynchronizer().finish();
    }

    public void executeActivity(@Observes Activity activity) {
        activity.perform();
    }

    public void awaitResponse(@Observes AwaitResponse event) {
        this.inspectionSynchronizer().waitForResponse();
    }

    public void cleanEnrichment(@Observes CleanEnrichment event) {
        this.inspectionSynchronizer().clean();
    }

    private WarpExecutor warpExecutor() {
        return (WarpExecutor)((ServiceLoader)this.services.get()).onlyOne(WarpExecutor.class);
    }

    private ExecutionSynchronizer inspectionSynchronizer() {
        return (ExecutionSynchronizer)((ServiceLoader)this.services.get()).onlyOne(ExecutionSynchronizer.class);
    }
}

