/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.execution;

import java.util.LinkedList;
import java.util.List;
import org.jboss.arquillian.warp.client.filter.Request;
import org.jboss.arquillian.warp.exception.ClientWarpExecutionException;
import org.jboss.arquillian.warp.impl.client.execution.WarpContext;
import org.jboss.arquillian.warp.impl.client.execution.WarpGroup;

public class WarpSynchronizationException
extends ClientWarpExecutionException {
    private static final long serialVersionUID = -9086096239081792164L;
    private String message;

    public WarpSynchronizationException(WarpContext context) {
        this.message = new MessageGenerator(context).generateMessage();
    }

    public String getMessage() {
        return this.message;
    }

    private static class MessageGenerator {
        private WarpContext context;
        private StringBuilder message = new StringBuilder();

        public MessageGenerator(WarpContext context) {
            this.context = context;
        }

        public String generateMessage() {
            this.generalIntroMessage();
            this.messageForRequestWithoutResponse();
            this.messageForUnsatisfiedObservers();
            this.messageForUnmatchedRequests();
            this.generalAdviceForDebugging();
            return this.message.toString();
        }

        private void generalIntroMessage() {
            this.message.append("The Warp failed to observe requests or match them with response.\n\n");
        }

        private void messageForRequestWithoutResponse() {
            LinkedList<Request> requestsWithoutResponse = new LinkedList<Request>();
            for (WarpGroup group : this.context.getAllGroups()) {
                requestsWithoutResponse.addAll(group.getRequestsWithoutResponse());
            }
            if (!requestsWithoutResponse.isEmpty()) {
                this.message.append("The warped request timed out when waiting for a response for following requests: ");
                this.message.append(requestsWithoutResponse);
                this.message.append("\n\n");
            }
        }

        private void messageForUnsatisfiedObservers() {
            LinkedList<WarpGroup> failedGroups = new LinkedList<WarpGroup>();
            for (WarpGroup group : this.context.getAllGroups()) {
                if (group.getHitCount() >= group.getExpectedRequestCount()) continue;
                failedGroups.add(group);
            }
            if (failedGroups.size() == 1 && ((WarpGroup)failedGroups.get(0)).getExpectedRequestCount() == 1) {
                this.message.append(String.format("There were no requests matched by observer [%s]\n\n", ((WarpGroup)failedGroups.get(0)).getObserver()));
            } else if (failedGroups.size() >= 1) {
                this.message.append("There were wrong number of requests matched by observers:\n");
                for (WarpGroup group : failedGroups) {
                    this.message.append(String.format(" - [%s]: %s requests expected, %s done", group.getObserver(), group.getExpectedRequestCount(), group.getHitCount()));
                }
                this.message.append("\n\n");
            }
        }

        private void messageForUnmatchedRequests() {
            List<Request> unmatchedRequests = this.context.getUnmatchedRequests();
            if (!unmatchedRequests.isEmpty()) {
                this.message.append(String.format("The %s other request/-s were noticed by Warp for the given activity: %s\n\n", unmatchedRequests.size(), unmatchedRequests));
            }
        }

        private void generalAdviceForDebugging() {
            this.message.append("If Warp enriched a wrong request, use observe(...) method to select appropriate request which should be enriched instead.\n");
            this.message.append("Otherwise check the server-side log and enable Arquillian debugging mode on both, test and server VM by passing -Darquillian.debug=true.\n");
        }
    }
}

