/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.warp.impl.client.proxy;

import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Queue;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.warp.impl.client.context.operation.ContextualOperation;
import org.jboss.arquillian.warp.impl.client.context.operation.Contextualizer;
import org.jboss.arquillian.warp.impl.client.context.operation.OperationalContext;
import org.jboss.arquillian.warp.impl.client.context.operation.OperationalContextRetriver;
import org.jboss.arquillian.warp.impl.client.context.operation.OperationalContexts;
import org.jboss.arquillian.warp.impl.client.proxy.ProxyService;
import org.jboss.arquillian.warp.impl.client.proxy.ProxyURLToContextMapping;
import org.littleshoot.proxy.ChainedProxy;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxyService
implements ProxyService<HttpProxyServer> {
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<OperationalContexts> operationalContexts;
    @Inject
    private Instance<ProxyURLToContextMapping> urlToContextMappingInst;

    @Override
    public HttpProxyServer startProxy(URL realUrl, final URL proxyUrl) {
        final ProxyURLToContextMapping urlToContextMapping = (ProxyURLToContextMapping)this.urlToContextMappingInst.get();
        OperationalContextRetriver retriever = new OperationalContextRetriver(){

            public OperationalContext retrieve() {
                return urlToContextMapping.get(proxyUrl);
            }
        };
        final HttpFiltersSourceAdapter httpFiltersSource = (HttpFiltersSourceAdapter)this.serviceLoader().onlyOne(HttpFiltersSourceAdapter.class);
        final 2 filterRequest = Contextualizer.contextualize(retriever, new ContextualOperation<HttpRequest, HttpFilters>(){

            @Override
            public HttpFilters performInContext(HttpRequest originalRequest) {
                return httpFiltersSource.filterRequest(originalRequest);
            }
        });
        InetSocketAddress bindToAddress = new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort());
        final InetSocketAddress forwardToAddress = new InetSocketAddress(realUrl.getHost(), realUrl.getPort());
        return DefaultHttpProxyServer.bootstrap().withAddress(bindToAddress).withTransparent(true).withChainProxyManager(new ChainedProxyManager(){

            public void lookupChainedProxies(HttpRequest httpRequest, Queue<ChainedProxy> chainedProxies) {
                chainedProxies.add((ChainedProxy)new ChainedProxyAdapter(){

                    public InetSocketAddress getChainedProxyAddress() {
                        return forwardToAddress;
                    }
                });
            }
        }).withFiltersSource((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest) {
                return (HttpFilters)filterRequest.performInContext(originalRequest);
            }

            public int getMaximumRequestBufferSizeInBytes() {
                return httpFiltersSource.getMaximumRequestBufferSizeInBytes();
            }

            public int getMaximumResponseBufferSizeInBytes() {
                return httpFiltersSource.getMaximumResponseBufferSizeInBytes();
            }
        }).start();
    }

    @Override
    public void stopProxy(HttpProxyServer proxy) {
        proxy.stop();
    }

    private ServiceLoader serviceLoader() {
        return (ServiceLoader)this.serviceLoader.get();
    }
}

